/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.statistics;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import org.limewire.mojito.KUID;
import org.limewire.mojito.statistics.DHTStatsManager;
import org.limewire.statistic.Statistic;

class StatisticContainer {
    public StatisticContainer() {
    }

    public StatisticContainer(KUID nodeId) {
        DHTStatsManager.getInstance(nodeId).addStatisticContainer(this);
    }

    public void writeStats(Writer writer) throws IOException {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> superclass = this.getClass().getSuperclass();
        Class<?> declaringClass = this.getClass().getDeclaringClass();
        if (superclass != null) {
            fields.addAll(Arrays.asList(superclass.getFields()));
        }
        if (declaringClass != null) {
            fields.addAll(Arrays.asList(declaringClass.getFields()));
        }
        fields.addAll(Arrays.asList(this.getClass().getFields()));
        for (Field field : fields) {
            try {
                Object value;
                if (Modifier.isTransient(field.getModifiers()) || !((value = field.get(this)) instanceof Statistic)) continue;
                Statistic stat = (Statistic)value;
                writer.write(field.getName() + "\t");
                stat.storeStats(writer);
                writer.write("\n");
            }
            catch (IllegalAccessException e) {}
        }
    }
}

