/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.zip.GZIPInputStream;
import org.limewire.mojito.exceptions.SignatureVerificationException;
import org.limewire.util.Base32;

public final class CryptoUtils {
    public static final String KEY_ALGORITHM = "DSA";
    public static final int KEY_SIZE = 1024;
    public static final String SIGNATURE_ALGORITHM = "SHA1withDSA";
    private static Signature SIGNATURE;

    private CryptoUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKey loadPublicKey(File file) throws IOException, SignatureException, InvalidKeyException {
        FileInputStream fis = null;
        GZIPInputStream gz = null;
        try {
            fis = new FileInputStream(file);
            gz = new GZIPInputStream(fis);
            PublicKey publicKey = CryptoUtils.loadPublicKey(gz);
            return publicKey;
        }
        finally {
            if (gz != null) {
                gz.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKey loadPublicKey(String base32) throws IOException, SignatureException, InvalidKeyException {
        ByteArrayInputStream bais = new ByteArrayInputStream(Base32.decode(base32));
        GZIPInputStream gz = null;
        try {
            gz = new GZIPInputStream(bais);
            PublicKey publicKey = CryptoUtils.loadPublicKey(gz);
            return publicKey;
        }
        finally {
            if (gz != null) {
                gz.close();
            }
        }
    }

    public static PublicKey loadPublicKey(InputStream in) throws IOException, SignatureException, InvalidKeyException {
        DataInputStream dis = new DataInputStream(in);
        byte[] signature = new byte[dis.readInt()];
        dis.readFully(signature);
        byte[] encodedKey = new byte[dis.readInt()];
        dis.readFully(encodedKey);
        PublicKey pubKey = CryptoUtils.createPublicKey(encodedKey);
        if (!CryptoUtils.verify(pubKey, signature, new byte[][]{encodedKey})) {
            throw new SignatureVerificationException();
        }
        return pubKey;
    }

    public static PublicKey createPublicKey(byte[] x509EncodedKey) {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(x509EncodedKey);
            KeyFactory factory = KeyFactory.getInstance(KEY_ALGORITHM);
            return factory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException err) {
            throw new RuntimeException(err);
        }
        catch (InvalidKeySpecException err) {
            throw new RuntimeException(err);
        }
    }

    public static synchronized byte[] sign(PrivateKey privateKey, byte[] ... data) throws SignatureException, InvalidKeyException {
        try {
            if (SIGNATURE == null) {
                SIGNATURE = Signature.getInstance(SIGNATURE_ALGORITHM);
            }
            SIGNATURE.initSign(privateKey);
            for (byte[] d : data) {
                SIGNATURE.update(d, 0, d.length);
            }
            return SIGNATURE.sign();
        }
        catch (NoSuchAlgorithmException err) {
            throw new RuntimeException(err);
        }
    }

    public static synchronized boolean verify(PublicKey publicKey, byte[] signature, byte[] ... data) throws SignatureException, InvalidKeyException {
        if (signature == null) {
            return false;
        }
        try {
            if (SIGNATURE == null) {
                SIGNATURE = Signature.getInstance(SIGNATURE_ALGORITHM);
            }
            SIGNATURE.initVerify(publicKey);
            for (byte[] d : data) {
                SIGNATURE.update(d, 0, d.length);
            }
            return SIGNATURE.verify(signature);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

