/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import org.limewire.nio.BufferInputStream;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.channel.ChannelReadObserver;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestScatteringByteChannel;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.nio.timeout.ReadTimeout;
import org.limewire.nio.timeout.SoTimeout;
import org.limewire.util.BufferUtils;

class NIOInputStream
implements ChannelReadObserver,
InterestScatteringByteChannel,
ReadTimeout {
    private final Shutdownable shutdownHandler;
    private final SoTimeout soTimeoutHandler;
    private InterestReadableByteChannel channel;
    private BufferInputStream source;
    private volatile Object bufferLock;
    private ByteBuffer buffer;
    private boolean shutdown;
    private boolean lastFilled = false;

    NIOInputStream(SoTimeout soTimeouter, Shutdownable shutdowner, InterestReadableByteChannel channel) {
        this.soTimeoutHandler = soTimeouter;
        this.shutdownHandler = shutdowner;
        this.channel = channel;
    }

    synchronized NIOInputStream init() throws IOException {
        if (this.buffer != null) {
            throw new IllegalStateException("already init'd!");
        }
        if (this.shutdown) {
            throw new IOException("Already closed!");
        }
        this.buffer = NIODispatcher.instance().getBufferCache().getHeap();
        this.source = new BufferInputStream(this.buffer, this, this.shutdownHandler, this.channel, this);
        this.bufferLock = this.source.getBufferLock();
        return this;
    }

    @Override
    public int read(ByteBuffer toBuffer) {
        return BufferUtils.transfer(this.buffer, toBuffer);
    }

    @Override
    public long read(ByteBuffer[] dst, int offset, int length) {
        return BufferUtils.transfer(this.buffer, dst, offset, length, true);
    }

    @Override
    public long read(ByteBuffer[] dst) {
        return this.read(dst, 0, dst.length);
    }

    synchronized InputStream getInputStream() throws IOException {
        if (this.buffer == null) {
            this.init();
        }
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRead() throws IOException {
        if (this.bufferLock == null) {
            int read = this.channel.read(BufferUtils.getEmptyBuffer());
            if (read == -1) {
                throw new ClosedChannelException();
            }
        } else {
            Object object = this.bufferLock;
            synchronized (object) {
                int read = 0;
                while (this.buffer.hasRemaining() && (read = this.channel.read(this.buffer)) > 0) {
                }
                if (read == -1) {
                    this.source.finished();
                }
                if (this.buffer.position() > 0 || read == -1) {
                    this.bufferLock.notify();
                }
                if (!this.buffer.hasRemaining()) {
                    this.lastFilled = true;
                    this.channel.interestRead(false);
                } else {
                    this.lastFilled = false;
                }
                if (read == -1) {
                    this.channel.interestRead(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readHappening() {
        Object object = this.bufferLock;
        synchronized (object) {
            if (this.lastFilled) {
                NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            NIOInputStream.this.handleRead();
                        }
                        catch (IOException iox) {
                            NIOInputStream.this.channel.interestRead(true);
                            NIOInputStream.this.shutdownHandler.shutdown();
                        }
                    }
                });
            }
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.source != null) {
            this.source.shutdown();
        }
        if (this.buffer != null) {
            NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    NIODispatcher.instance().getBufferCache().release(NIOInputStream.this.buffer);
                }
            });
        }
    }

    @Override
    public void handleIOException(IOException iox) {
        throw new RuntimeException("unsupported operation", iox);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void interestRead(boolean status) {
        this.channel.interestRead(status);
    }

    @Override
    public InterestReadableByteChannel getReadChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadChannel(InterestReadableByteChannel newChannel) {
        this.channel = newChannel;
        NIOInputStream nIOInputStream = this;
        synchronized (nIOInputStream) {
            if (this.source != null) {
                this.source.setReadChannel(newChannel);
            }
        }
    }

    @Override
    public long getReadTimeout() {
        try {
            return this.soTimeoutHandler.getSoTimeout();
        }
        catch (SocketException se) {
            return -1L;
        }
    }
}

