/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.observer.WriteObserver;

public class DeflaterWriter
implements ChannelWriter,
InterestWritableByteChannel {
    private volatile InterestWritableByteChannel channel;
    private volatile WriteObserver observer;
    private ByteBuffer outgoing;
    private ByteBuffer incoming;
    private Deflater deflater;
    private int sync = 0;
    private static final byte[] EMPTY = new byte[0];

    public DeflaterWriter(Deflater deflater) {
        this(deflater, null);
    }

    public DeflaterWriter(Deflater deflater, InterestWritableByteChannel channel) {
        this.deflater = deflater;
        this.incoming = ByteBuffer.allocate(4096);
        this.outgoing = ByteBuffer.allocate(512);
        this.outgoing.flip();
        this.channel = channel;
    }

    @Override
    public InterestWritableByteChannel getWriteChannel() {
        return this.channel;
    }

    @Override
    public void setWriteChannel(InterestWritableByteChannel channel) {
        this.channel = channel;
        channel.interestWrite(this, true);
    }

    @Override
    public synchronized void interestWrite(WriteObserver observer, boolean status) {
        this.observer = status ? observer : null;
        InterestWritableByteChannel source = this.channel;
        if (source != null) {
            source.interestWrite(this, true);
        }
    }

    @Override
    public int write(ByteBuffer buffer) throws IOException {
        int wrote = 0;
        if (this.incoming.hasRemaining()) {
            int adding;
            int remaining = this.incoming.remaining();
            if (remaining >= (adding = buffer.remaining())) {
                this.incoming.put(buffer);
                wrote = adding;
            } else {
                int oldLimit = buffer.limit();
                int position = buffer.position();
                buffer.limit(position + remaining);
                this.incoming.put(buffer);
                buffer.limit(oldLimit);
                wrote = remaining;
            }
        }
        return wrote;
    }

    @Override
    public void close() throws IOException {
        InterestWritableByteChannel source = this.channel;
        if (source != null) {
            source.close();
        }
    }

    @Override
    public boolean isOpen() {
        InterestWritableByteChannel source = this.channel;
        return source != null ? source.isOpen() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleWrite() throws IOException {
        InterestWritableByteChannel source = this.channel;
        if (source == null) {
            throw new IllegalStateException("writing with no source.");
        }
        block9: while (true) {
            this.channel.write(this.outgoing);
            if (this.outgoing.hasRemaining()) {
                return true;
            }
            while (true) {
                int deflated;
                try {
                    deflated = this.deflater.deflate(this.outgoing.array());
                }
                catch (NullPointerException npe) {
                    throw (IOException)new IOException().initCause(npe);
                }
                if (deflated > 0) {
                    this.outgoing.position(0).limit(deflated);
                    continue block9;
                }
                try {
                    if (this.sync == 0) {
                        this.deflater.setInput(EMPTY);
                        this.deflater.setLevel(0);
                        this.sync = 1;
                        continue;
                    }
                    if (this.sync == 1) {
                        this.deflater.setLevel(-1);
                        this.sync = 2;
                        continue;
                    }
                }
                catch (NullPointerException npe) {
                    throw (IOException)new IOException().initCause(npe);
                }
                if (this.incoming.position() == 0) {
                    WriteObserver interested = this.observer;
                    if (interested != null) {
                        interested.handleWrite();
                    }
                    if (this.incoming.position() == 0) {
                        DeflaterWriter deflaterWriter = this;
                        synchronized (deflaterWriter) {
                            if (this.observer == null) {
                                source.interestWrite(this, false);
                            }
                        }
                        return false;
                    }
                }
                try {
                    this.deflater.setInput(this.incoming.array(), 0, this.incoming.position());
                }
                catch (NullPointerException npe) {
                    throw (IOException)new IOException().initCause(npe);
                }
                this.incoming.clear();
                this.sync = 0;
            }
            break;
        }
    }

    @Override
    public void shutdown() {
        WriteObserver listener = this.observer;
        if (listener != null) {
            listener.shutdown();
        }
    }

    @Override
    public void handleIOException(IOException x) {
        throw new RuntimeException("Unsupported", x);
    }

    @Override
    public boolean hasBufferedOutput() {
        InterestWritableByteChannel channel = this.channel;
        return this.incoming.position() > 0 || this.outgoing.hasRemaining() || channel != null && channel.hasBufferedOutput();
    }
}

