/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.statemachine;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.nio.statemachine.IOState;
import org.limewire.util.FileUtils;

public class BlockingStateMachine
implements Closeable,
Shutdownable {
    private static final Log LOG = LogFactory.getLog(BlockingStateMachine.class);
    private final List<IOState> states;
    private final ReadableByteChannel readChannel;
    private final WritableByteChannel writeChannel;
    private final ByteBuffer readBuffer;

    public BlockingStateMachine(List<IOState> states, InputStream in, OutputStream out) {
        this(states, 2048, in, out);
    }

    public BlockingStateMachine(List<IOState> states, int bufferSize, InputStream in, OutputStream out) {
        this.states = states;
        this.readBuffer = NIODispatcher.instance().getBufferCache().getHeap(bufferSize);
        this.readChannel = Channels.newChannel(in);
        this.writeChannel = Channels.newChannel(out);
    }

    public void addState(IOState newState) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding single state: " + newState);
        }
        this.states.add(newState);
    }

    public void addStates(List<? extends IOState> newStates) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding multiple states: " + newStates);
        }
        this.states.addAll(newStates);
    }

    public void addStates(IOState ... newStates) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding multiple states...");
        }
        for (int i = 0; i < newStates.length; ++i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(" state[" + i + "]: " + newStates[i]);
            }
            this.states.add(newStates[i]);
        }
    }

    @Override
    public void close() {
        FileUtils.close(this.readChannel);
        FileUtils.close(this.writeChannel);
    }

    @Override
    public void shutdown() {
        NIODispatcher.instance().getBufferCache().release(this.readBuffer);
    }

    public void process() throws IOException {
        Iterator<IOState> i = this.states.iterator();
        while (i.hasNext()) {
            IOState current = i.next();
            if (current.isReading()) {
                current.process(this.readChannel, this.readBuffer);
            } else if (current.isWriting()) {
                current.process(this.writeChannel, null);
            } else {
                throw new IllegalStateException("expected reading | writing state");
            }
            i.remove();
        }
    }
}

