/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.timeout;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.nio.timeout.Timeoutable;

public class TimeoutController {
    private static final Log LOG = LogFactory.getLog(TimeoutController.class);
    private final PriorityQueue<Timeout> items = new PriorityQueue(20);
    private final List<Timeout> timedout = new ArrayList<Timeout>(100);

    public synchronized int getNumPendingTimeouts() {
        return this.items.size();
    }

    public synchronized void addTimeout(Timeoutable t, long now, long timeout) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding timeoutable: " + t + ", now: " + now + ", timeout: " + timeout);
        }
        this.items.offer(new Timeout(t, now, timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTimeouts(long now) {
        Timeout t;
        TimeoutController timeoutController = this;
        synchronized (timeoutController) {
            while (!this.items.isEmpty()) {
                t = this.items.peek();
                if (t != null && now >= t.expireTime) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Timing out: " + t + ", expired: " + t.expireTime + ", now: " + now + ", length: " + t.timeoutLength);
                    }
                } else {
                    if (t == null || !LOG.isDebugEnabled()) break;
                    LOG.debug("Breaking -- next timeout at: " + t.expireTime + ", now: " + now);
                    break;
                }
                this.timedout.add(t);
                this.items.poll();
            }
        }
        for (int i = 0; i < this.timedout.size(); ++i) {
            t = this.timedout.get(i);
            t.timeoutable.notifyTimeout(now, t.expireTime, t.timeoutLength);
        }
        this.timedout.clear();
    }

    public synchronized long getNextExpireTime() {
        if (this.items.isEmpty()) {
            return -1L;
        }
        return this.items.peek().expireTime;
    }

    private static class Timeout
    implements Comparable<Timeout> {
        private final long expireTime;
        private final Timeoutable timeoutable;
        private final long timeoutLength;

        Timeout(Timeoutable timeoutable, long now, long timeout) {
            this.expireTime = timeout > 0L && Long.MAX_VALUE - timeout < now ? Long.MAX_VALUE : now + timeout;
            this.timeoutLength = timeout;
            this.timeoutable = timeoutable;
        }

        @Override
        public int compareTo(Timeout b) {
            return this.expireTime > b.expireTime ? 1 : (this.expireTime < b.expireTime ? -1 : 0);
        }

        public String toString() {
            return "TimeoutWrapper for: " + this.timeoutable;
        }
    }
}

