/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.player.impl;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.limewire.player.api.AudioSource;

public class AudioSourceImpl
implements AudioSource {
    private final File file;
    private final URL url;
    private final InputStream inputStream;

    public AudioSourceImpl(File file) {
        if (file == null) {
            throw new NullPointerException("File cannot be null");
        }
        this.file = file;
        this.url = null;
        this.inputStream = null;
    }

    public AudioSourceImpl(URL url) {
        if (url == null) {
            throw new NullPointerException("URL cannot be null");
        }
        this.url = url;
        this.file = null;
        this.inputStream = null;
    }

    public AudioSourceImpl(InputStream stream) {
        if (stream == null) {
            throw new NullPointerException("InputStream cannot be null");
        }
        this.inputStream = stream;
        this.file = null;
        this.url = null;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public InputStream getStream() {
        return this.inputStream;
    }

    @Override
    public URL getURL() {
        if (this.url != null) {
            return this.url;
        }
        if (this.file != null) {
            try {
                return this.file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }
}

