/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.promotion;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.limewire.promotion.PromotionBinder;
import org.limewire.promotion.PromotionBinderFactory;
import org.limewire.promotion.PromotionBinderRequestor;
import org.limewire.promotion.impressions.UserQueryEvent;
import org.limewire.promotion.impressions.UserQueryEventData;
import org.limewire.util.StringUtils;

public abstract class AbstractPromotionBinderRequestor
implements PromotionBinderRequestor {
    private final PromotionBinderFactory binderFactory;

    public AbstractPromotionBinderRequestor(PromotionBinderFactory binderFactory) {
        this.binderFactory = binderFactory;
    }

    @Override
    public final PromotionBinder request(String url, long id, Set<? extends UserQueryEvent> queries) {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(2 * queries.size() + 1);
        nameValuePairs.add(new BasicNameValuePair("id", String.valueOf(id)));
        int i = 0;
        for (UserQueryEvent userQueryEvent : queries) {
            UserQueryEventData data = new UserQueryEventData(userQueryEvent);
            String dataStr = StringUtils.getASCIIString(new Base64().encode(data.getData()));
            nameValuePairs.add(new BasicNameValuePair("query_" + i, data.getQuery()));
            nameValuePairs.add(new BasicNameValuePair("data_" + i, dataStr));
            ++i;
        }
        HttpPost tmp = null;
        String string = this.alterUrl(url);
        HttpPost request = tmp = new HttpPost(string);
        try {
            request.setEntity(new UrlEncodedFormEntity(nameValuePairs));
        }
        catch (UnsupportedEncodingException e) {
            this.error(e);
            return null;
        }
        BasicHttpParams params = new BasicHttpParams();
        request.addHeader("User-Agent", this.getUserAgent());
        try {
            return this.binderFactory.newBinder(this.makeRequest(request, params));
        }
        catch (HttpException e) {
            this.error(e);
        }
        catch (IOException e) {
            this.error(e);
        }
        return null;
    }

    protected abstract void error(Exception var1);

    protected abstract String getUserAgent();

    protected abstract String alterUrl(String var1);

    protected abstract InputStream makeRequest(HttpPost var1, HttpParams var2) throws HttpException, IOException;

    public static String encode(String string) {
        try {
            return URLEncoder.encode(string, "8859_1");
        }
        catch (UnsupportedEncodingException uee) {
            return string;
        }
    }
}

