/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.promotion;

import org.limewire.util.ByteUtils;

public class LatitudeLongitude {
    private static final double AVERAGE_EARTH_RADIUS_KM = 6371.0;
    private final byte[] latitude;
    private final byte[] longitude;

    public LatitudeLongitude(byte[] latitude, byte[] longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public LatitudeLongitude(double latitudeDegrees, double longitudeDegrees) {
        this(LatitudeLongitude.convertDegreesToBytes(latitudeDegrees, 3), LatitudeLongitude.convertDegreesToBytes(longitudeDegrees, 3));
    }

    static byte[] convertDegreesToBytes(double degrees, int byteCount) {
        double scale = Math.pow(2.0, 8 * byteCount) / 360.0;
        long value = (long)(LatitudeLongitude.normalizeDegrees(degrees) * scale);
        return ByteUtils.long2bytes(value, byteCount);
    }

    private static double normalizeDegrees(double degrees) {
        while (degrees < 0.0) {
            degrees += 360.0;
        }
        return degrees % 360.0;
    }

    static double toRadians(byte[] bytes) {
        long value = ByteUtils.beb2long(bytes, 0, bytes.length);
        return Math.toRadians((double)value / (Math.pow(2.0, 8 * bytes.length) / 360.0));
    }

    private double getLatitudeRadians() {
        return LatitudeLongitude.toRadians(this.latitude);
    }

    private double getLongitudeRadians() {
        return LatitudeLongitude.toRadians(this.longitude);
    }

    public double distanceFrom(LatitudeLongitude otherPoint) {
        double lat = this.getLatitudeRadians();
        double lon = this.getLongitudeRadians();
        double otherlat = otherPoint.getLatitudeRadians();
        double otherlon = otherPoint.getLongitudeRadians();
        double p1 = Math.cos(lat) * Math.cos(lon) * Math.cos(otherlat) * Math.cos(otherlon);
        double p2 = Math.cos(lat) * Math.sin(lon) * Math.cos(otherlat) * Math.sin(otherlon);
        double p3 = Math.sin(lat) * Math.sin(otherlat);
        return Math.acos(p1 + p2 + p3) * 6371.0;
    }

    public byte[] toBytes() {
        byte[] array = new byte[6];
        System.arraycopy(this.to3Bytes(this.latitude), 0, array, 0, 3);
        System.arraycopy(this.to3Bytes(this.longitude), 0, array, 3, 3);
        return array;
    }

    private byte[] to3Bytes(byte[] in) {
        if (in.length == 3) {
            return in;
        }
        double value = LatitudeLongitude.toRadians(in);
        return LatitudeLongitude.convertDegreesToBytes(Math.toDegrees(value), 3);
    }
}

