/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.promotion.containers;

import java.io.IOException;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Arrays;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.GGEP;
import org.limewire.io.IOUtils;
import org.limewire.promotion.containers.MessageContainer;
import org.limewire.promotion.containers.MessageContainerParser;
import org.limewire.security.certificate.CertificateVerifier;
import org.limewire.security.certificate.CipherProvider;
import org.limewire.security.certificate.KeyStoreProvider;
import org.limewire.util.StringUtils;

public class SignedMessageContainer
implements MessageContainer {
    private static final String KEY_WRAPPED_BYTES = "W";
    private static final String KEY_SIGNATURE = "S";
    private static final String KEY_ALIAS = "A";
    private GGEP payload = new GGEP();

    @Override
    public byte[] getType() {
        return StringUtils.toUTF8Bytes("SIGN");
    }

    @Override
    public byte[] encode() {
        this.payload.put("T", this.getType());
        return this.payload.toByteArray();
    }

    @Override
    public void decode(GGEP rawGGEP) throws BadGGEPBlockException {
        if (!Arrays.equals(this.getType(), rawGGEP.get("T"))) {
            throw new BadGGEPBlockException("Incorrect type.");
        }
        if (!rawGGEP.hasKey(KEY_ALIAS)) {
            throw new BadGGEPBlockException("Missing alias");
        }
        if (!rawGGEP.hasKey(KEY_SIGNATURE)) {
            throw new BadGGEPBlockException("Missing signature");
        }
        if (!rawGGEP.hasKey(KEY_WRAPPED_BYTES)) {
            throw new BadGGEPBlockException("Missing wrapped message");
        }
        this.payload = rawGGEP;
    }

    public void setAndSignWrappedMessage(MessageContainer wrappedMessage, CipherProvider cipherProvider, PrivateKey privateKey, String keyAlias) throws IOException {
        byte[] messagePayload = wrappedMessage.encode();
        byte[] signature = cipherProvider.sign(messagePayload, privateKey, CipherProvider.SignatureType.SHA1_WITH_RSA);
        this.payload = new GGEP();
        this.payload.put(KEY_WRAPPED_BYTES, messagePayload);
        this.payload.put(KEY_SIGNATURE, signature);
        this.payload.put(KEY_ALIAS, StringUtils.toUTF8Bytes(keyAlias));
    }

    public MessageContainer getAndVerifyWrappedMessage(CipherProvider cipherProvider, KeyStoreProvider keyStore, CertificateVerifier certificateVerifier) throws IOException {
        try {
            String keyAlias = StringUtils.toUTF8String(this.payload.getBytes(KEY_ALIAS));
            Certificate cert = keyStore.getKeyStore().getCertificate(keyAlias);
            if (!certificateVerifier.isValid(cert)) {
                throw new IOException("Invalid certificate retrieved.");
            }
            byte[] wrappedBytes = this.payload.getBytes(KEY_WRAPPED_BYTES);
            if (!cipherProvider.verify(wrappedBytes, this.payload.getBytes(KEY_SIGNATURE), cert.getPublicKey(), CipherProvider.SignatureType.SHA1_WITH_RSA)) {
                throw new IOException("Wrapped message did not match the signature.");
            }
            return new MessageContainerParser().parse(wrappedBytes);
        }
        catch (BadGGEPBlockException ex) {
            throw IOUtils.getIOException("BadGGEPBlockException parsing contents:", ex);
        }
        catch (KeyStoreException ex) {
            throw IOUtils.getIOException("KeyStoreException parsing contents:", ex);
        }
        catch (BadGGEPPropertyException ex) {
            throw IOUtils.getIOException("BadGGEPPropertyException parsing contents:", ex);
        }
    }
}

