/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp;

import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.rudp.MessageDispatcher;
import org.limewire.rudp.UDPMultiplexor;
import org.limewire.rudp.messages.RUDPMessage;

public class DefaultMessageDispatcher
implements MessageDispatcher {
    private static final Log LOG = LogFactory.getLog(DefaultMessageDispatcher.class);
    private final Executor executor = ExecutorsHelper.newProcessingQueue("RUDPDispatch");
    private volatile UDPMultiplexor multiplexor;

    void setUDPMultiplexor(UDPMultiplexor plexor) {
        if (this.multiplexor != null) {
            LOG.warn("Overriding old multiplexor!");
        }
        this.multiplexor = plexor;
    }

    @Override
    public void dispatch(RUDPMessage message, InetSocketAddress from) {
        this.executor.execute(new Dispatch(this.multiplexor, message, from));
    }

    private static class Dispatch
    implements Runnable {
        private final UDPMultiplexor plexor;
        private final RUDPMessage msg;
        private final InetSocketAddress from;

        Dispatch(UDPMultiplexor plexor, RUDPMessage msg, InetSocketAddress from) {
            this.plexor = plexor;
            this.msg = msg;
            this.from = from;
        }

        @Override
        public void run() {
            this.plexor.routeMessage(this.msg, this.from);
        }
    }
}

