/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.swarm.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.limewire.collection.Range;
import org.limewire.io.IOUtils;
import org.limewire.swarm.SwarmFile;
import org.limewire.swarm.SwarmFileSystem;
import org.limewire.swarm.file.SwarmFileImpl;

public class FileChannelSwarmFileSystem
implements SwarmFileSystem {
    private final SwarmFile swarmFile;
    private RandomAccessFile raFile;
    private FileChannel fileChannel;
    private final Object LOCK = new Object();

    public FileChannelSwarmFileSystem(long completeSize, File file) {
        this.swarmFile = new SwarmFileImpl(file, completeSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer byteBuffer, long start) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            this.initialize();
            long written = this.fileChannel.write(byteBuffer, start);
            return written;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(ByteBuffer byteBuffer, long position) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            this.initialize();
            long read = this.fileChannel.read(byteBuffer, position);
            return read;
        }
    }

    @Override
    public long getCompleteSize() {
        return this.swarmFile.getFileSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.raFile != null) {
                IOUtils.close(this.fileChannel);
                IOUtils.close(this.raFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.raFile == null) {
                this.raFile = new RandomAccessFile(this.swarmFile.getFile(), "rw");
                this.fileChannel = this.raFile.getChannel();
            }
        }
    }

    @Override
    public SwarmFile getSwarmFile(long position) {
        return this.swarmFile;
    }

    @Override
    public List<SwarmFile> getSwarmFiles() {
        ArrayList<SwarmFile> files = new ArrayList<SwarmFile>();
        files.add(this.swarmFile);
        return files;
    }

    @Override
    public void closeSwarmFile(SwarmFile swarmFile) throws IOException {
        this.close();
    }

    public List<SwarmFile> getSwarmFiles(Range range) {
        return this.getSwarmFiles();
    }
}

