/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.ui.support.DeadlockBugManager;
import org.limewire.ui.support.DeadlockException;
import org.limewire.util.ThreadUtils;

public class DeadlockSupport {
    private static Log LOG = LogFactory.getLog(DeadlockSupport.class);
    private static final int DEADLOCK_CHECK_INTERVAL = 30001;

    public static void startDeadlockMonitoring() {
        Thread t = ThreadExecutor.newManagedThread(new Runnable(){

            @Override
            public void run() {
                long[] ids;
                while (true) {
                    try {
                        Thread.sleep(30001L);
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                    LOG.trace("deadlock check start");
                    ids = ThreadUtils.findDeadlockedThreads();
                    if (ids != null) break;
                    LOG.trace("no deadlocks found");
                }
                StringBuilder sb = new StringBuilder("Deadlock Report:\n");
                StackTraceElement[] firstStackTrace = ThreadUtils.buildStackTraces(ids, sb);
                DeadlockException deadlock = new DeadlockException();
                if (firstStackTrace != null) {
                    deadlock.setStackTrace(firstStackTrace);
                }
                DeadlockBugManager.handleDeadlock(deadlock, Thread.currentThread().getName(), sb.toString());
            }
        });
        t.setDaemon(true);
        t.setName("Deadlock Detection Thread");
        t.start();
    }
}

