/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.activation;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.jxlayer.JXLayer;
import org.limewire.activation.api.ActivationError;
import org.limewire.activation.api.ActivationEvent;
import org.limewire.activation.api.ActivationItem;
import org.limewire.activation.api.ActivationManager;
import org.limewire.activation.api.ActivationState;
import org.limewire.core.api.Application;
import org.limewire.listener.EventListener;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.action.UrlAction;
import org.limewire.ui.swing.activation.ActivationTable;
import org.limewire.ui.swing.activation.ActivationUtilities;
import org.limewire.ui.swing.activation.ActivationWarningPanel;
import org.limewire.ui.swing.activation.LabelWithLinkSupport;
import org.limewire.ui.swing.activation.LicenseKeyPanel;
import org.limewire.ui.swing.activation.LicenseKeyTextField;
import org.limewire.ui.swing.activation.LostLicenseItem;
import org.limewire.ui.swing.components.ColoredBusyLabel;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.LimeJDialog;
import org.limewire.ui.swing.components.TextFieldClipboardControl;
import org.limewire.ui.swing.options.actions.OKDialogAction;
import org.limewire.ui.swing.table.CalendarRenderer;
import org.limewire.ui.swing.table.TableCellHeaderRenderer;
import org.limewire.ui.swing.util.BackgroundExecutorService;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.ResizeUtils;
import org.limewire.util.NotImplementedException;
import org.limewire.util.OSUtils;

public class ActivationPanel {
    @Resource
    private int tableWidth;
    @Resource
    private Font font;
    @Resource
    private Color fontColor;
    @Resource
    private Color errorColor;
    @Resource
    private Icon unsupportedIcon;
    private static final String NO_LICENSE_BUTTON_PANEL = "NO_LICENSE_PANEL";
    private static final String EDIT_LICENSE_BUTTON_PANEL = "EDIT_PANEL";
    private static final String OK_LICENSE_BUTTON_PANEL = "OK_PANEL";
    private final ActivationManager activationManager;
    private final Application application;
    private final ActivationListener listener;
    private final EventList<ActivationItem> eventList;
    private final StateManager stateManager;
    private final Map<String, ButtonPanel> cardMap = new HashMap<String, ButtonPanel>();
    private JPanel activationPanel;
    private JDialog dialog;
    private LicenseKeyTextField licenseField;
    private LicenseKeyPanel licenseKeyPanel;
    private ActivationWarningPanel warningPanel;
    private JButton editButton;
    private JXLayer tableJXLayer;
    private ActivationTable table;
    private JScrollPane scrollPane;
    private ColoredBusyLabel tableOverlayBusyLabel;
    private JLabel licenseErrorLabel;
    private UnderneathActivationTableMessagePanel underneathModuleTableMessagePanel;
    private JPanel cardPanel;
    private CardLayout cardLayout;

    @Inject
    public ActivationPanel(ActivationManager activationManager, CalendarRenderer calendarRenderer, Application application) {
        this.activationManager = activationManager;
        this.application = application;
        this.listener = new ActivationListener();
        this.eventList = new BasicEventList<ActivationItem>();
        this.stateManager = new StateManager();
        this.initComponents(calendarRenderer, application);
    }

    private void initComponents(CalendarRenderer calendarRenderer, Application application) {
        GuiUtils.assignResources(this);
        if (OSUtils.isMacOSX()) {
            this.tableWidth += 20;
        }
        this.activationPanel = new JPanel(new MigLayout("gap 0, fillx, insets 20 20 20 20"));
        this.activationPanel.setBackground(GuiUtils.getMainFrame().getBackground());
        JLabel licenseKeyLabel = new JLabel(I18n.tr("License Key:"));
        licenseKeyLabel.setFont(this.font);
        licenseKeyLabel.setForeground(this.fontColor);
        this.licenseField = new LicenseKeyTextField(25);
        this.licenseField.setFont(this.font);
        this.licenseField.setForeground(this.fontColor);
        this.licenseField.addActionListener(new ActivateAction());
        TextFieldClipboardControl.install(this.licenseField);
        this.licenseKeyPanel = new LicenseKeyPanel(this.licenseField);
        this.warningPanel = new ActivationWarningPanel();
        this.editButton = new JButton(new EditAction());
        this.licenseErrorLabel = new JLabel();
        this.licenseErrorLabel.setFont(this.font);
        this.licenseErrorLabel.setForeground(this.errorColor);
        this.underneathModuleTableMessagePanel = new UnderneathActivationTableMessagePanel();
        this.table = new ActivationTable(this.eventList, calendarRenderer, application);
        this.scrollPane = new JScrollPane(this.table);
        int height = 4 * this.table.getRowHeight() + this.table.getTableHeader().getPreferredSize().height + this.scrollPane.getInsets().top + this.scrollPane.getInsets().bottom;
        this.tableOverlayBusyLabel = new ColoredBusyLabel(new Dimension(20, 20));
        JPanel busyLabelPanel = new JPanel(new MigLayout("align 50% 50%"));
        busyLabelPanel.add(Box.createVerticalStrut(10), "wrap");
        busyLabelPanel.add(this.tableOverlayBusyLabel);
        busyLabelPanel.setOpaque(false);
        this.tableJXLayer = new JXLayer<JScrollPane>(this.scrollPane);
        this.tableJXLayer.getGlassPane().setLayout(new BorderLayout());
        this.tableJXLayer.getGlassPane().add((Component)busyLabelPanel, "Center");
        this.tableJXLayer.getGlassPane().setVisible(false);
        this.activationPanel.add((Component)licenseKeyLabel, "gapright 10, growy 0");
        this.activationPanel.add((Component)this.licenseKeyPanel.getComponent(), "growx, width 230!, growy 0");
        this.activationPanel.add((Component)this.warningPanel.getComponent(), "gapleft 6, aligny 50%, growy 0");
        this.activationPanel.add((Component)this.editButton, "gapleft 16, align 100% 50%, growy 0, wrap");
        this.activationPanel.add((Component)this.licenseErrorLabel, "span, growx, aligny 50%, height 27!, wrap");
        this.activationPanel.add((Component)this.tableJXLayer, "span, grow, gapbottom 10, height " + height + "!, width " + this.tableWidth + ", gpy 200, wrap");
        this.activationPanel.add((Component)this.underneathModuleTableMessagePanel, "hidemode 3, width " + this.tableWidth + "!, span, growx, wrap");
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.setOpaque(false);
        this.activationPanel.add((Component)this.cardPanel, "span, gaptop 10, growx, wrap");
    }

    protected void configureEnclosingScrollPane(JScrollPane scrollPane) {
        JTableHeader th = new JTableHeader();
        th.setDefaultRenderer(new TableCellHeaderRenderer());
        Component renderer = th.getDefaultRenderer().getTableCellRendererComponent(null, "", false, false, -1, -1);
        JPanel cornerComponent = new JPanel(new BorderLayout());
        cornerComponent.add(renderer, "Center");
        scrollPane.setCorner("UPPER_RIGHT_CORNER", cornerComponent);
    }

    @Inject
    public void register() {
        this.activationManager.addListener(this.listener);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ActivationPanel.this.configureEnclosingScrollPane(ActivationPanel.this.scrollPane);
            }
        });
    }

    public void show() {
        this.licenseField.setText(this.activationManager.getLicenseKey());
        ActivationError error = ActivationError.NO_ERROR;
        if (this.activationManager.getActivationError() == ActivationError.BLOCKED_KEY) {
            error = this.activationManager.getActivationError();
        }
        this.stateManager.setActivationState(this.activationManager.getActivationState(), error);
        this.dialog = new LimeJDialog(GuiUtils.getMainFrame());
        this.dialog.setModal(true);
        this.dialog.setResizable(false);
        this.dialog.setTitle(I18n.tr("License"));
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.add(this.activationPanel);
        this.dialog.pack();
        this.dialog.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ActivationPanel.this.dispose();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                ActivationPanel.this.dialog.pack();
            }
        });
        this.dialog.setLocationRelativeTo(GuiUtils.getMainFrame());
        this.dialog.setVisible(true);
    }

    private void dispose() {
        if (this.listener != null) {
            this.activationManager.removeListener(this.listener);
        }
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    private void selectCard(String card) {
        if (!this.cardMap.containsKey(card)) {
            if (card.equals(NO_LICENSE_BUTTON_PANEL)) {
                NoLicenseButtonPanel noLicenseButtonPanel = new NoLicenseButtonPanel();
                this.cardMap.put(card, noLicenseButtonPanel);
                this.cardPanel.add((Component)noLicenseButtonPanel, card);
            } else if (card.equals(OK_LICENSE_BUTTON_PANEL)) {
                ActivatedButtonPanel activatedButtonPanel = new ActivatedButtonPanel();
                this.cardMap.put(card, activatedButtonPanel);
                this.cardPanel.add((Component)activatedButtonPanel, card);
            } else if (card.equals(EDIT_LICENSE_BUTTON_PANEL)) {
                EditButtonPanel editButtonPanel = new EditButtonPanel();
                this.cardMap.put(card, editButtonPanel);
                this.cardPanel.add((Component)editButtonPanel, card);
            }
        }
        this.cardLayout.show(this.cardPanel, card);
    }

    private class ActivationListener
    implements EventListener<ActivationEvent> {
        private ActivationListener() {
        }

        @Override
        public void handleEvent(final ActivationEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActivationPanel.this.stateManager.setActivationState((ActivationState)((Object)event.getData()), event.getError());
                }
            });
        }
    }

    private class RefreshAction
    extends AbstractAction {
        public RefreshAction(String name, String description) {
            this.putValue("Name", name);
            this.putValue("ShortDescription", description);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BackgroundExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    ActivationPanel.this.activationManager.refreshKey(ActivationPanel.this.licenseField.getText().trim().replaceAll("-", ""));
                }
            });
        }
    }

    private class ActivateAction
    extends AbstractAction {
        public ActivateAction() {
            this("", "");
        }

        public ActivateAction(String name, String description) {
            this.putValue("Name", name);
            this.putValue("ShortDescription", description);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BackgroundExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    ActivationPanel.this.activationManager.activateKey(ActivationPanel.this.licenseField.getText().trim().replaceAll("-", ""));
                }
            });
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("ShortDescription", I18n.tr("Cancel editing"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActivationPanel.this.stateManager.setActivationState(ActivationState.AUTHORIZED, ActivationError.NO_ERROR);
        }
    }

    private class EditAction
    extends AbstractAction {
        public EditAction() {
            this.putValue("Name", I18n.tr("Edit Key"));
            this.putValue("ShortDescription", I18n.tr("Edit the saved License Key"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActivationPanel.this.stateManager.setEditingLicense(true);
        }
    }

    private class UnderneathActivationTableMessagePanel
    extends JPanel {
        private final JLabel iconLabel;
        private final LabelWithLinkSupport textLabel;

        public UnderneathActivationTableMessagePanel() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.iconLabel = new JLabel(ActivationPanel.this.unsupportedIcon);
            this.iconLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
            this.textLabel = new LabelWithLinkSupport();
            this.textLabel.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)this.iconLabel, "West");
            this.add((Component)this.textLabel, "Center");
        }

        public void setState(MessageState state) {
            switch (state) {
                case BLOCKED: {
                    this.textLabel.setText("<html><font size=\"3\" face=\"" + ActivationPanel.this.font.getFontName() + "\">" + I18n.tr("Please contact {0}Customer Support{1} to resolve the situation.", "<a href='" + ActivationPanel.this.application.addClientInfoToUrl("http://www.limewire.com/client_redirect/?page=proSupport") + "'>", "</a>") + "</font></html>");
                    this.iconLabel.setVisible(false);
                    this.textLabel.setVisible(true);
                    ResizeUtils.forceSize(this, new Dimension(ActivationPanel.this.tableWidth, 17));
                    return;
                }
                case EXPIRED: {
                    this.textLabel.setText("<html><font size=\"3\" face=\"" + ActivationPanel.this.font.getFontName() + "\">" + I18n.tr("One or more of your features has expired. Click \"Edit Account\" to renew.") + "</font></html>");
                    this.iconLabel.setVisible(true);
                    this.textLabel.setVisible(true);
                    ResizeUtils.forceSize(this, new Dimension(ActivationPanel.this.tableWidth, 17));
                    return;
                }
                case UNSUPPORTED: {
                    this.textLabel.setText("<html><font size=\"3\" face=\"" + ActivationPanel.this.font.getFontName() + "\">" + I18n.tr("One or more of your features is currently not active. Click on {0} for more information.", "<img src='" + ActivationUtilities.getInfoIconURL() + "'>") + "</font></html>");
                    this.iconLabel.setVisible(true);
                    this.textLabel.setVisible(true);
                    ResizeUtils.forceSize(this, new Dimension(ActivationPanel.this.tableWidth, 34));
                    return;
                }
                case NO_ERROR: {
                    this.iconLabel.setVisible(false);
                    this.textLabel.setVisible(false);
                    ResizeUtils.forceSize(this, new Dimension(ActivationPanel.this.tableWidth, 0));
                    return;
                }
            }
            throw new NotImplementedException("State does not exist");
        }
    }

    private static enum MessageState {
        BLOCKED,
        EXPIRED,
        UNSUPPORTED,
        NO_ERROR;

    }

    private class ActivatedButtonPanel
    extends ButtonPanel {
        private final JButton refreshButton;
        private final HyperlinkButton editAccountButton;

        public ActivatedButtonPanel() {
            this.refreshButton = new JButton(new RefreshAction(I18n.tr("Refresh"), I18n.tr("Refresh the list of features associated with the key")));
            JButton okButton = new JButton(new OKDialogAction());
            String accountSettingsUrl = ActivationPanel.this.application.addClientInfoToUrl("http://www.limewire.com/client_redirect/?page=accountDetails");
            this.editAccountButton = new HyperlinkButton(new UrlAction(I18n.tr("Edit Account"), accountSettingsUrl));
            this.editAccountButton.setToolTipText(I18n.tr("Edit information about the account associated with this License Key"));
            this.add((Component)this.refreshButton, "split");
            this.add((Component)this.editAccountButton, "push");
            this.add((Component)okButton, "split, alignx 100%, tag ok, wrap");
        }

        @Override
        public void setIsActivating(boolean enabled) {
            this.refreshButton.setEnabled(!enabled);
        }
    }

    private class EditButtonPanel
    extends ButtonPanel
    implements PropertyChangeListener {
        private final JButton updateButton;

        public EditButtonPanel() {
            this.updateButton = new JButton(new ActivateAction(I18n.tr("Update"), I18n.tr("Update the saved key")));
            JButton cancelButton = new JButton(new CancelAction());
            ActivationPanel.this.licenseField.addPropertyChangeListener(this);
            this.updateButton.setEnabled(ActivationPanel.this.licenseField.getText().length() == 14);
            this.add((Component)this.updateButton, "alignx 100%, gapright 10, tag ok, split");
            this.add((Component)cancelButton, "wrap, tag cancel");
        }

        public void finalize() {
            if (ActivationPanel.this.licenseField != null) {
                ActivationPanel.this.licenseField.removePropertyChangeListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("License Complete")) {
                Boolean enabled = (Boolean)evt.getNewValue();
                this.updateButton.setEnabled(enabled);
            }
        }

        @Override
        public void setIsActivating(boolean activating) {
            this.updateButton.setEnabled(!activating && ActivationPanel.this.licenseField.getText().length() == 14);
        }
    }

    private class NoLicenseButtonPanel
    extends ButtonPanel
    implements PropertyChangeListener {
        private final JButton activateButton;

        public NoLicenseButtonPanel() {
            JButton goProButton = new JButton(new UrlAction(I18n.tr("Go PRO"), ActivationPanel.this.application.addClientInfoToUrl("http://www.limewire.com/client_redirect/?page=downloadPro")));
            goProButton.setToolTipText(I18n.tr("Upgrade to PRO"));
            this.activateButton = new JButton(new ActivateAction(I18n.tr("Activate"), I18n.tr("Activate the License Key")));
            JButton laterButton = new JButton(new OKDialogAction(I18n.tr("Later"), I18n.tr("Activate License at a later time")));
            ActivationPanel.this.licenseField.addPropertyChangeListener(this);
            this.activateButton.setEnabled(ActivationPanel.this.licenseField.getText().length() == 14);
            this.add((Component)goProButton, "push");
            this.add((Component)this.activateButton, "split, gapright 10, tag ok");
            this.add((Component)laterButton, "tag cancel, wrap");
        }

        public void finalize() {
            if (ActivationPanel.this.licenseField != null) {
                ActivationPanel.this.licenseField.removePropertyChangeListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("License Complete")) {
                Boolean enabled = (Boolean)evt.getNewValue();
                this.activateButton.setEnabled(enabled);
            }
        }

        @Override
        public void setIsActivating(boolean activating) {
            this.activateButton.setEnabled(!activating && ActivationPanel.this.licenseField.getText().length() == 14);
        }
    }

    private abstract class ButtonPanel
    extends JPanel {
        public ButtonPanel() {
            super(new MigLayout("fillx, gap 0, insets 0"));
            this.setOpaque(false);
        }

        public abstract void setIsActivating(boolean var1);
    }

    private class StateManager {
        private boolean editingLicense = true;
        private ActivationState state = ActivationState.NOT_AUTHORIZED;
        private ActivationError error = ActivationError.NO_ERROR;

        private StateManager() {
        }

        public void setEditingLicense(boolean editingLicense) {
            ActivationPanel.this.editButton.setVisible(false);
            ActivationPanel.this.licenseKeyPanel.setEditable(true);
            ActivationPanel.this.licenseField.requestFocusInWindow();
            ActivationPanel.this.licenseField.selectAll();
            ActivationPanel.this.warningPanel.setActivationMode(ActivationWarningPanel.Mode.EMPTY);
            ActivationPanel.this.selectCard(ActivationPanel.EDIT_LICENSE_BUTTON_PANEL);
            this.editingLicense = editingLicense;
        }

        public void setActivationState(ActivationState state, ActivationError error) {
            this.state = state;
            this.error = error;
            if (state == ActivationState.AUTHORIZED) {
                this.editingLicense = false;
                ActivationPanel.this.licenseKeyPanel.setKey(ActivationPanel.this.activationManager.getLicenseKey());
            }
            ActivationPanel.this.eventList.clear();
            if (state == ActivationState.AUTHORIZED || state == ActivationState.REFRESHING) {
                ActivationPanel.this.eventList.addAll(ActivationPanel.this.activationManager.getActivationItems());
            } else if (state == ActivationState.NOT_AUTHORIZED && error != ActivationError.BLOCKED_KEY) {
                ActivationPanel.this.eventList.add(new LostLicenseItem(ActivationPanel.this.application));
            }
            this.update();
            if (ActivationPanel.this.dialog != null) {
                ActivationPanel.this.dialog.pack();
            }
        }

        public void update() {
            boolean isEditMode = this.editingLicense || this.state == ActivationState.NOT_AUTHORIZED || this.state == ActivationState.AUTHORIZING;
            ActivationPanel.this.licenseKeyPanel.setEditable(isEditMode);
            ActivationWarningPanel.Mode warningPanelMode = ActivationWarningPanel.Mode.EMPTY;
            if (this.state == ActivationState.AUTHORIZING) {
                warningPanelMode = ActivationWarningPanel.Mode.SPINNER;
            } else if (this.state == ActivationState.NOT_AUTHORIZED && (this.error == ActivationError.INVALID_KEY || this.error == ActivationError.BLOCKED_KEY)) {
                warningPanelMode = ActivationWarningPanel.Mode.WARNING;
            }
            ActivationPanel.this.warningPanel.setActivationMode(warningPanelMode);
            ActivationPanel.this.editButton.setVisible(!isEditMode);
            ActivationPanel.this.licenseErrorLabel.setText(this.getLicenseErrorMessage(this.error));
            if (this.state == ActivationState.REFRESHING) {
                ActivationPanel.this.editButton.setEnabled(false);
                ActivationPanel.this.tableOverlayBusyLabel.setBusy(true);
                ActivationPanel.this.tableJXLayer.getGlassPane().setVisible(true);
            } else {
                ActivationPanel.this.editButton.setEnabled(true);
                ActivationPanel.this.tableOverlayBusyLabel.setBusy(false);
                ActivationPanel.this.tableJXLayer.getGlassPane().setVisible(false);
            }
            if (this.error == ActivationError.BLOCKED_KEY) {
                ActivationPanel.this.underneathModuleTableMessagePanel.setState(MessageState.BLOCKED);
            } else if (this.areThereExpiredModules()) {
                ActivationPanel.this.underneathModuleTableMessagePanel.setState(MessageState.EXPIRED);
            } else if (this.areThereNonFunctionalModules()) {
                ActivationPanel.this.underneathModuleTableMessagePanel.setState(MessageState.UNSUPPORTED);
            } else {
                ActivationPanel.this.underneathModuleTableMessagePanel.setState(MessageState.NO_ERROR);
            }
            String cardName = ActivationPanel.NO_LICENSE_BUTTON_PANEL;
            if (this.state == ActivationState.AUTHORIZED) {
                cardName = isEditMode ? ActivationPanel.EDIT_LICENSE_BUTTON_PANEL : ActivationPanel.OK_LICENSE_BUTTON_PANEL;
            } else if (this.state == ActivationState.REFRESHING) {
                cardName = ActivationPanel.OK_LICENSE_BUTTON_PANEL;
            }
            ActivationPanel.this.selectCard(cardName);
            ((ButtonPanel)ActivationPanel.this.cardMap.get(cardName)).setIsActivating(this.state == ActivationState.REFRESHING || this.state == ActivationState.AUTHORIZING);
            ActivationPanel.this.activationPanel.revalidate();
        }

        private boolean areThereExpiredModules() {
            for (ActivationItem item : ActivationPanel.this.activationManager.getActivationItems()) {
                if (item.getStatus() != ActivationItem.Status.EXPIRED) continue;
                return true;
            }
            return false;
        }

        private boolean areThereNonFunctionalModules() {
            for (ActivationItem item : ActivationPanel.this.activationManager.getActivationItems()) {
                if (item.getStatus() != ActivationItem.Status.UNAVAILABLE && item.getStatus() != ActivationItem.Status.UNUSEABLE_LW && item.getStatus() != ActivationItem.Status.UNUSEABLE_OS) continue;
                return true;
            }
            return false;
        }

        private String getLicenseErrorMessage(ActivationError error) {
            switch (error) {
                case BLOCKED_KEY: {
                    return I18n.tr("Your License Key has been used on too many installations.");
                }
                case COMMUNICATION_ERROR: {
                    return I18n.tr("Connection error. Please try again later.");
                }
                case INVALID_KEY: {
                    return I18n.tr("Invalid License Key.");
                }
            }
            return "";
        }
    }
}

