/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.activation;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.limewire.activation.api.ActivationItem;
import org.limewire.core.api.Application;
import org.limewire.ui.swing.action.UrlAction;
import org.limewire.ui.swing.activation.ActivationInfoAction;
import org.limewire.ui.swing.activation.ActivationItemComparator;
import org.limewire.ui.swing.activation.LostLicenseItem;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.IconButton;
import org.limewire.ui.swing.table.AbstractTableFormat;
import org.limewire.ui.swing.table.CalendarRenderer;
import org.limewire.ui.swing.table.MouseableTable;
import org.limewire.ui.swing.table.TableCellHeaderRenderer;
import org.limewire.ui.swing.table.TableColors;
import org.limewire.ui.swing.table.TableRendererEditor;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.OSUtils;

class ActivationTable
extends MouseableTable {
    @Resource
    private Icon infoIcon;
    @Resource
    private Color expiredColor;
    @Resource
    private Font rendererFont;
    @Resource
    private int columnWidth;
    private final DefaultEventTableModel<ActivationItem> model;
    private final Application application;

    public ActivationTable(EventList<ActivationItem> eventList, CalendarRenderer calendarRenderer, Application application) {
        GuiUtils.assignResources(this);
        this.model = new DefaultEventTableModel<ActivationItem>(new SortedList<ActivationItem>(eventList, new ActivationItemComparator()), new ActivationTableFormat());
        this.setModel(this.model);
        this.application = application;
        if (OSUtils.isMacOSX()) {
            this.columnWidth += 10;
        }
        this.initTable();
        this.getColumnExt(1).setMinWidth(this.columnWidth);
        this.getColumnExt(1).setMaxWidth(this.columnWidth);
        this.getColumnExt(2).setMinWidth(this.columnWidth);
        this.getColumnExt(2).setMaxWidth(this.columnWidth);
        this.getColumn(0).setCellRenderer(new LicenseTypeEditorRenderer());
        this.getColumn(0).setCellEditor(new LicenseTypeEditorRenderer());
        this.getColumn(1).setCellRenderer(calendarRenderer);
        this.getColumn(2).setCellRenderer(new ExpiredRendererEditor());
        ExpiredRendererEditor expiredRenderer = new ExpiredRendererEditor();
        expiredRenderer.addActionListener(new ActivationInfoAction(expiredRenderer, this, application));
        this.getColumn(2).setCellEditor(expiredRenderer);
        this.setupHighlighters();
    }

    @Override
    protected void setTableHeaderRenderer() {
        JTableHeader th = this.getTableHeader();
        TableCellHeaderRenderer renderer = new TableCellHeaderRenderer();
        renderer.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        th.setDefaultRenderer(renderer);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return null;
    }

    private void initTable() {
        this.setShowHorizontalLines(false);
        this.setSelectionMode(0);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        this.setCellSelectionEnabled(false);
        this.setFillsViewportHeight(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(false);
    }

    private void setupHighlighters() {
        TableColors tableColors = new TableColors();
        ColorHighlighter unsupportedHighlighter = new ColorHighlighter(new GrayHighlightPredicate(), null, tableColors.getDisabledForegroundColor(), null, tableColors.getDisabledForegroundColor());
        this.addHighlighter(unsupportedHighlighter);
    }

    private class ExpiredRendererEditor
    extends TableRendererEditor {
        private final JLabel dateLabel;
        private final IconButton iconButton;
        private final JLabel expiredLabel;
        private ActivationItem cellEditorValue = null;

        public ExpiredRendererEditor() {
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this.dateLabel = new JLabel();
            this.dateLabel.setFont(ActivationTable.this.rendererFont);
            this.iconButton = new IconButton(ActivationTable.this.infoIcon);
            this.expiredLabel = new JLabel(I18n.tr("Expired"));
            this.expiredLabel.setForeground(ActivationTable.this.expiredColor);
            this.expiredLabel.setFont(ActivationTable.this.rendererFont);
            this.iconButton.setVisible(false);
            this.expiredLabel.setVisible(false);
            FontMetrics metrics = this.getFontMetrics(ActivationTable.this.rendererFont);
            int fontWidth = metrics.stringWidth("12/30/30");
            this.setLayout(new MigLayout("fill, insets 0, hidemode 3", "[][grow]", "[]"));
            this.add((Component)this.dateLabel, "alignx left, width " + fontWidth + "!, aligny 50%");
            this.add((Component)this.iconButton, "split 2, align 50%");
            this.add((Component)this.expiredLabel, "align 50%");
        }

        public void addActionListener(ActionListener listener) {
            this.iconButton.addActionListener(listener);
        }

        @Override
        public ActivationItem getCellEditorValue() {
            return this.cellEditorValue;
        }

        @Override
        public void setForeground(Color bg) {
            if (this.dateLabel != null) {
                this.dateLabel.setForeground(bg);
            }
        }

        @Override
        protected Component doTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.cellEditorValue = value instanceof ActivationItem && ((ActivationItem)value).getDateExpired() != null ? (ActivationItem)value : null;
            return this.updateComponent(table, value, isSelected, row, column);
        }

        @Override
        protected Component doTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.updateComponent(table, value, isSelected, row, column);
        }

        private Component updateComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof ActivationItem && ((ActivationItem)value).getDateExpired() != null) {
                ActivationItem item = (ActivationItem)value;
                this.dateLabel.setText(GuiUtils.date2String(item.getDateExpired()));
                this.iconButton.setVisible(item.getStatus() == ActivationItem.Status.UNAVAILABLE || item.getStatus() == ActivationItem.Status.UNUSEABLE_LW || item.getStatus() == ActivationItem.Status.UNUSEABLE_OS);
                this.expiredLabel.setVisible(item.getStatus() == ActivationItem.Status.EXPIRED);
            } else {
                this.dateLabel.setText("");
                this.iconButton.setVisible(false);
                this.expiredLabel.setVisible(false);
            }
            return this;
        }
    }

    private class LicenseTypeEditorRenderer
    extends TableRendererEditor {
        private final JLabel nameLabel = new JLabel();
        private final HyperlinkButton licenseButton;
        private final UrlAction licenseAction;

        public LicenseTypeEditorRenderer() {
            this.nameLabel.setVisible(false);
            this.nameLabel.setFont(ActivationTable.this.rendererFont);
            String accountSettingsUrl = ActivationTable.this.application.addClientInfoToUrl("http://www.limewire.com/client_redirect/?page=accountDetails");
            this.licenseAction = new UrlAction(I18n.tr("Lost your license?"), accountSettingsUrl);
            this.licenseButton = new HyperlinkButton(this.licenseAction);
            this.licenseButton.setVisible(false);
            this.setLayout(new MigLayout("fill, insets 0 5 0 5, hidemode 3"));
            this.add(this.nameLabel);
            this.add(this.licenseButton);
        }

        @Override
        public void setForeground(Color bg) {
            if (this.nameLabel != null) {
                this.nameLabel.setForeground(bg);
            }
        }

        @Override
        protected Component doTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.updateComponent(table, value, isSelected, false, row, column);
        }

        @Override
        protected Component doTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.updateComponent(table, value, isSelected, hasFocus, row, column);
        }

        private Component updateComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof LostLicenseItem) {
                LostLicenseItem item = (LostLicenseItem)value;
                this.nameLabel.setVisible(false);
                this.licenseButton.setText(item.getLicenseName());
                this.licenseAction.setURL(item.getURL());
                this.licenseButton.setVisible(true);
            } else if (value instanceof ActivationItem) {
                this.nameLabel.setText(this.getText((ActivationItem)value));
                this.nameLabel.setVisible(true);
                this.licenseButton.setVisible(false);
            } else {
                this.nameLabel.setVisible(false);
                this.licenseButton.setVisible(false);
            }
            return this;
        }

        private String getText(ActivationItem item) {
            if (item.getStatus() == ActivationItem.Status.ACTIVE) {
                return item.getLicenseName();
            }
            return "<html><s>" + item.getLicenseName() + "</s></html>";
        }
    }

    private class ActivationTableFormat
    extends AbstractTableFormat<ActivationItem> {
        private static final int MODULE_TYPE_INDEX = 0;
        private static final int DATE_REGISTERED_INDEX = 1;
        private static final int DATE_EXPIRE_INDEX = 2;

        public ActivationTableFormat() {
            super(I18n.tr("Feature"), I18n.tr("Registered"), I18n.tr("Expires"));
        }

        @Override
        public Object getColumnValue(ActivationItem baseObject, int column) {
            switch (column) {
                case 0: {
                    return baseObject;
                }
                case 1: {
                    return baseObject.getDatePurchased();
                }
                case 2: {
                    return baseObject;
                }
            }
            throw new IllegalStateException("Unknown column: " + column);
        }
    }

    private class GrayHighlightPredicate
    implements HighlightPredicate {
        private GrayHighlightPredicate() {
        }

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            ActivationItem item = (ActivationItem)ActivationTable.this.model.getElementAt(adapter.row);
            return item.getStatus() == ActivationItem.Status.EXPIRED || item.getStatus() == ActivationItem.Status.UNAVAILABLE || item.getStatus() == ActivationItem.Status.UNUSEABLE_LW || item.getStatus() == ActivationItem.Status.UNUSEABLE_OS;
        }
    }
}

