/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.advanced;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import org.limewire.ui.swing.advanced.Console;
import org.limewire.ui.swing.advanced.TabPanel;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.LogUtils;

public class ConsolePanel
extends TabPanel {
    private BorderLayout panelLayout = new BorderLayout();
    private JLabel naLabel = new JLabel();
    private Console console;

    @Inject
    public ConsolePanel(Console console) {
        this.console = console;
        this.initComponents();
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(this.panelLayout);
        if (LogUtils.isLog4JAvailable()) {
            this.console.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            this.add((Component)this.console, "Center");
        } else {
            this.naLabel.setText(I18n.tr("Console not available"));
            this.naLabel.setHorizontalAlignment(0);
            this.naLabel.setVerticalAlignment(0);
            this.add((Component)this.naLabel, "Center");
        }
    }

    @Override
    public void setBackground(Color bgColor) {
        super.setBackground(bgColor);
        if (this.console != null) {
            this.console.setBackground(bgColor);
        }
    }

    @Override
    public boolean isTabEnabled() {
        return true;
    }

    @Override
    public void initData() {
        this.console.attachLogs();
    }

    @Override
    public void dispose() {
        this.console.removeLogs();
    }
}

