/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.animate;

import java.awt.Point;
import javax.swing.JWindow;
import org.limewire.listener.EventListener;
import org.limewire.ui.swing.animate.AbstractAnimator;
import org.limewire.ui.swing.animate.AnimatorEvent;

public class MoveAnimator
extends AbstractAnimator<JWindow> {
    public MoveAnimator(final JWindow window, int totalTime, final Point newPoint) {
        super(window, totalTime);
        double xDifference = Math.ceil(newPoint.getX() - window.getLocation().getX());
        double yDifference = Math.ceil(newPoint.getY() - (double)window.getY());
        final double xStep = xDifference / (double)this.getTotalNumberOfSteps();
        final double yStep = yDifference / (double)this.getTotalNumberOfSteps();
        this.addListener((EventListener)new EventListener<AnimatorEvent<JWindow>>(){

            @Override
            public void handleEvent(AnimatorEvent event) {
                if (event.getType() == AnimatorEvent.Type.STEP) {
                    Point currentLocation = window.getLocation();
                    Point newLocation = new Point((int)Math.ceil(currentLocation.getX() + xStep), (int)Math.ceil(currentLocation.getY() + yStep));
                    window.setLocation(newLocation);
                } else if (event.getType() == AnimatorEvent.Type.STOPPED) {
                    window.setLocation(newPoint);
                }
            }
        });
    }
}

