/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.browser;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.core.settings.MozillaSettings;
import org.limewire.io.Expand;
import org.limewire.io.IOUtils;
import org.limewire.ui.swing.browser.MozillaPopupPanel;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;
import org.mozilla.browser.IMozillaWindow;
import org.mozilla.browser.IMozillaWindowFactory;
import org.mozilla.browser.MozillaConfig;
import org.mozilla.browser.MozillaInitialization;
import org.mozilla.browser.MozillaWindow;
import org.mozilla.browser.impl.WindowCreator;

public class LimeMozillaInitializer {
    private static final Log LOG = LogFactory.getLog(LimeMozillaInitializer.class);

    private LimeMozillaInitializer() {
    }

    public static boolean shouldInitialize() {
        return (OSUtils.isWindows() || OSUtils.isLinux() || OSUtils.isMacOSX()) && LimeMozillaInitializer.is32BitProcess() && MozillaSettings.USE_MOZILLA.getValue();
    }

    private static boolean is32BitProcess() {
        return "i386".equals(OSUtils.getOSArch()) || "x86".equals(OSUtils.getOSArch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void initialize() {
        if (!LimeMozillaInitializer.shouldInitialize()) {
            return;
        }
        File xulInstallPath = new File(CommonUtils.getUserSettingsDir(), "/browser");
        File xulFile = new File(xulInstallPath, "xul-v2.0b2.5-do-not-remove");
        if (!xulFile.exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("unzip xulrunner to " + xulInstallPath);
            }
            FileUtils.deleteRecursive(xulInstallPath);
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(CommonUtils.getResourceStream(LimeMozillaInitializer.getResourceName()));
                Expand.expandFile(in, xulInstallPath, true, null);
                xulFile.createNewFile();
            }
            catch (IOException e) {
                IOUtils.close(in);
                catch (Throwable throwable) {
                    IOUtils.close(in);
                    throw throwable;
                }
            }
            IOUtils.close(in);
        }
        LimeMozillaInitializer.installFlashLinux(xulInstallPath);
        String newLibraryPath = System.getProperty("java.library.path") + File.pathSeparator + xulInstallPath.getAbsolutePath();
        System.setProperty("java.library.path", newLibraryPath);
        MozillaConfig.setXULRunnerHome(xulInstallPath);
        File profileDir = new File(CommonUtils.getUserSettingsDir(), "/mozilla-profile");
        profileDir.mkdirs();
        MozillaConfig.setProfileDir(profileDir);
        WindowCreator.setWindowFactory(new IMozillaWindowFactory(){

            @Override
            public IMozillaWindow create(boolean attachNewBrowserOnCreation) {
                MozillaPopupPanel popupPanel = new MozillaPopupPanel(attachNewBrowserOnCreation);
                MozillaWindow popupWindow = new MozillaWindow(popupPanel);
                return popupWindow;
            }
        });
        MozillaInitialization.initialize();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Moz Summary: " + MozillaConfig.getConfigSummary());
        }
    }

    private static void installFlashLinux(File xulInstallPath) {
        File pluginsDir = new File(xulInstallPath, "/xulrunner/plugins");
        if (OSUtils.isLinux()) {
            File[] possibleFlashLocations;
            for (File file : pluginsDir.listFiles()) {
                if (!file.isFile() || !file.getName().contains("flash")) continue;
                return;
            }
            for (File flashLocation : possibleFlashLocations = new File[]{new File("/usr/lib/flash-plugin/"), new File("/usr/lib/firefox/plugins"), new File("/usr/lib/mozilla/plugins"), new File("/usr/lib/iceweasle"), new File("/usr/lib/xulrunner"), new File(CommonUtils.getUserHomeDir(), "/.mozilla/plugins")}) {
                if (!flashLocation.exists() || !flashLocation.isDirectory()) continue;
                boolean foundFlash = false;
                for (File flashFile : flashLocation.listFiles()) {
                    if (!flashFile.getName().contains("flash")) continue;
                    File linkTarget = new File(pluginsDir, "/" + flashFile.getName());
                    try {
                        FileUtils.createSymbolicLink(flashFile, linkTarget);
                        foundFlash = true;
                    }
                    catch (IOException e) {
                        LOG.debug(e.getMessage(), e);
                    }
                    catch (InterruptedException e) {
                        LOG.debug(e.getMessage(), e);
                    }
                }
                if (foundFlash) break;
            }
        }
    }

    private static String getResourceName() {
        if (OSUtils.isWindows()) {
            return "xulrunner-win32.zip";
        }
        if (OSUtils.isLinux()) {
            return "xulrunner-linux.zip";
        }
        if (OSUtils.isMacOSX()) {
            return "xulrunner-macosx-i386.zip";
        }
        throw new IllegalStateException("no resource for OS: " + OSUtils.getOS());
    }
}

