/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.limewire.ui.swing.components.HTMLLabel;
import org.limewire.ui.swing.components.LimeJDialog;
import org.limewire.ui.swing.components.LimeJFrame;
import org.limewire.ui.swing.components.MultiLineLabel;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

public class FocusJOptionPane {
    private static final List<String> visibleDialogs = new ArrayList<String>();

    public static Component createFocusComponent() {
        LimeJFrame frame = new LimeJFrame("LimeWire");
        frame.setUndecorated(true);
        frame.setSize(0, 0);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2, screenSize.height / 2);
        frame.setVisible(true);
        return frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType) throws HeadlessException {
        String messageString = message.toString();
        if (visibleDialogs.contains(messageString)) {
            return;
        }
        visibleDialogs.add(messageString);
        boolean dispose = false;
        parentComponent = FocusJOptionPane.getWindowForComponent(parentComponent);
        if (parentComponent == null) {
            parentComponent = FocusJOptionPane.createFocusComponent();
            dispose = true;
        }
        Color oldOptionColor = UIManager.getColor("OptionPane.background");
        Color oldPanelColor = UIManager.getColor("Panel.background");
        if (GuiUtils.getMainFrame() != null) {
            UIManager.put("OptionPane.background", GuiUtils.getMainFrame().getBackground());
            UIManager.put("Panel.background", GuiUtils.getMainFrame().getBackground());
        }
        try {
            JOptionPane.showMessageDialog(parentComponent, message, title, messageType);
        }
        finally {
            visibleDialogs.remove(messageString);
            if (dispose) {
                ((JFrame)parentComponent).dispose();
            }
            UIManager.put("OptionPane.background", oldOptionColor);
            UIManager.put("Panel.background", oldPanelColor);
        }
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType) throws HeadlessException {
        boolean dispose = false;
        if ((parentComponent = FocusJOptionPane.getWindowForComponent(parentComponent)) == null) {
            parentComponent = FocusJOptionPane.createFocusComponent();
            dispose = true;
        }
        return FocusJOptionPane.showConfirmationDialog(parentComponent, message, title, optionType, 3, null, null, dispose);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) throws HeadlessException {
        boolean dispose = false;
        if ((parentComponent = FocusJOptionPane.getWindowForComponent(parentComponent)) == null) {
            parentComponent = FocusJOptionPane.createFocusComponent();
            dispose = true;
        }
        return FocusJOptionPane.showConfirmationDialog(parentComponent, message, title, optionType, messageType, null, null, dispose);
    }

    public static int showOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) throws HeadlessException {
        boolean dispose = false;
        if ((parentComponent = FocusJOptionPane.getWindowForComponent(parentComponent)) == null) {
            parentComponent = FocusJOptionPane.createFocusComponent();
            dispose = true;
        }
        return FocusJOptionPane.showConfirmationDialog(parentComponent, message, title, optionType, messageType, options, initialValue, dispose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int showConfirmationDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Object[] options, Object initialValue, boolean dispose) {
        Color oldOptionColor = UIManager.getColor("OptionPane.background");
        Color oldPanelColor = UIManager.getColor("Panel.background");
        UIManager.put("OptionPane.background", GuiUtils.getMainFrame().getBackground());
        UIManager.put("Panel.background", GuiUtils.getMainFrame().getBackground());
        try {
            int n = JOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, null, options, initialValue);
            return n;
        }
        finally {
            if (dispose) {
                ((JFrame)parentComponent).dispose();
            }
            UIManager.put("OptionPane.background", oldOptionColor);
            UIManager.put("Panel.background", oldPanelColor);
        }
    }

    public static JDialog createDialog(String title, JComponent parent, JComponent contentPane) {
        Window window = FocusJOptionPane.getWindowForComponent(parent);
        LimeJDialog dialog = window instanceof Frame ? new LimeJDialog((Frame)window, title, true) : new LimeJDialog((Dialog)window, title, true);
        Container frameContentPane = dialog.getContentPane();
        frameContentPane.setLayout(new BorderLayout());
        frameContentPane.add((Component)contentPane, "Center");
        contentPane.setOpaque(false);
        frameContentPane.setBackground(GuiUtils.getMainFrame().getBackground());
        dialog.setResizable(false);
        dialog.setLocationRelativeTo(parent);
        dialog.pack();
        return dialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showYesNoMessage(String message, String title, int defaultOption, JComponent parent) {
        int option;
        Object[] options = new String[]{I18n.tr("Yes"), I18n.tr("No")};
        Color oldOptionColor = UIManager.getColor("OptionPane.background");
        Color oldPanelColor = UIManager.getColor("Panel.background");
        UIManager.put("OptionPane.background", GuiUtils.getMainFrame().getBackground());
        UIManager.put("Panel.background", GuiUtils.getMainFrame().getBackground());
        try {
            option = FocusJOptionPane.showOptionDialog(FocusJOptionPane.getWindowForComponent(parent), FocusJOptionPane.getLabel(message), title, 0, 2, null, options, defaultOption);
        }
        catch (InternalError ie) {
            option = 1;
        }
        finally {
            UIManager.put("OptionPane.background", oldOptionColor);
            UIManager.put("Panel.background", oldPanelColor);
        }
        return option;
    }

    private static JComponent getLabel(String message) {
        if (message.startsWith("<html")) {
            HTMLLabel label = new HTMLLabel(message);
            label.setMargin(new Insets(5, 5, 5, 5));
            return label;
        }
        return new MultiLineLabel(message, 400);
    }

    public static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return GuiUtils.getMainFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return FocusJOptionPane.getWindowForComponent(parentComponent.getParent());
    }
}

