/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import org.jdesktop.swingx.painter.AbstractPainter;

public class LimeProgressBar
extends JProgressBar {
    private static final boolean CACHING_SUPPORTED = true;
    private AbstractPainter<JProgressBar> foregroundPainter;
    private AbstractPainter<JComponent> backgroundPainter;

    public LimeProgressBar() {
    }

    public LimeProgressBar(int min, int max) {
        super(min, max);
    }

    public void setForegroundPainter(AbstractPainter<JProgressBar> painter) {
        this.foregroundPainter = painter;
        painter.setCacheable(this.hasCacheSupport());
    }

    public void setBackgroundPainter(AbstractPainter<JComponent> painter) {
        this.backgroundPainter = painter;
    }

    public boolean hasCacheSupport() {
        return true;
    }

    @Override
    public void setValue(int v) {
        if (this.getValue() != v) {
            this.foregroundPainter.clearCache();
            this.backgroundPainter.clearCache();
        }
        super.setValue(v);
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.isEnabled() != b) {
            this.foregroundPainter.clearCache();
            this.backgroundPainter.clearCache();
        }
        super.setEnabled(b);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.foregroundPainter == null || this.backgroundPainter == null) {
            super.paintComponent(g);
        } else {
            this.backgroundPainter.paint((Graphics2D)g, this, this.getWidth(), this.getHeight());
            this.foregroundPainter.paint((Graphics2D)g, this, this.getWidth(), this.getHeight());
        }
    }
}

