/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.ui.swing.components.PopupCloseButton;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.PainterUtils;
import org.limewire.ui.swing.util.ResizeUtils;

public class PopupHeaderBar
extends JPanel {
    @Resource
    private Font font;
    @Resource
    private Color background = PainterUtils.TRASPARENT;
    private final JLabel titleBarLabel;

    public PopupHeaderBar(String title, Action closeAction) {
        super(new MigLayout("gap 0, insets 0, fill"));
        GuiUtils.assignResources(this);
        ResizeUtils.forceHeight(this, 21);
        this.setBackground(this.background);
        this.titleBarLabel = new JLabel(title);
        this.titleBarLabel.setOpaque(false);
        this.titleBarLabel.setForeground(Color.WHITE);
        this.titleBarLabel.setFont(this.font);
        this.add((Component)this.titleBarLabel, "gapleft 4, gaptop 1, dock west");
        if (closeAction != null) {
            PopupCloseButton closeButton = new PopupCloseButton();
            closeButton.addActionListener(closeAction);
            this.add((Component)closeButton, "gapright 3, gaptop 1, dock east");
        }
    }

    public void setIcon(Icon icon) {
        this.titleBarLabel.setIcon(icon);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.titleBarLabel != null) {
            this.titleBarLabel.setFont(font);
        }
    }
}

