/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.dock;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.limewire.service.ErrorService;
import org.limewire.ui.swing.util.MacOSXUtils;
import org.limewire.util.OSUtils;

public class Dock {
    private static final boolean HAS_DOCK;
    public static final int ICON_WIDTH = 128;
    public static final int ICON_HEIGHT = 128;

    private Dock() {
    }

    public static Object getDockLock() {
        return Dock.class;
    }

    public static synchronized void setDockTileImage(Icon icon) {
        Dock.paintIcon(icon, false);
    }

    public static synchronized void setDockTileOverlayImage(Icon icon) {
        Dock.paintIcon(icon, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void paintIcon(Icon icon, boolean overlay) {
        if (!HAS_DOCK) {
            return;
        }
        if (icon == null) {
            throw new NullPointerException("Icon is null");
        }
        int[] pixel = new int[16384];
        BufferedImage image = new BufferedImage(128, 128, 2);
        JPanel panel = new JPanel();
        Dimension iconSize = new Dimension(128, 128);
        panel.setSize(iconSize);
        ((Component)panel).setPreferredSize(iconSize);
        ((Component)panel).setMinimumSize(iconSize);
        ((Component)panel).setMaximumSize(iconSize);
        image.setRGB(0, 0, 128, 128, pixel, 0, 128);
        Graphics2D g = image.createGraphics();
        try {
            icon.paintIcon(panel, g, 0, 0);
        }
        finally {
            g.dispose();
        }
        image.getRGB(0, 0, 128, 128, pixel, 0, 128);
        Dock.DrawDockTileImage(pixel, overlay, MacOSXUtils.getAppDir());
    }

    public static synchronized void restoreDockTileImage() {
        if (HAS_DOCK) {
            Dock.RestoreApplicationDockTileImage(MacOSXUtils.getAppDir());
        }
    }

    public static synchronized int requestUserAttention(AttentionType requestType) {
        if (HAS_DOCK) {
            return Dock.RequestUserAttention(requestType.type);
        }
        return -1;
    }

    public static synchronized void cancelUserAttentionRequest(int request) {
        if (HAS_DOCK) {
            Dock.CancelUserAttentionRequest(request);
        }
    }

    private static final native void DrawDockTileImage(int[] var0, boolean var1, String var2);

    private static final native void RestoreApplicationDockTileImage(String var0);

    private static final native int RequestUserAttention(int var0);

    private static final native void CancelUserAttentionRequest(int var0);

    static {
        boolean hasDock = false;
        if (OSUtils.isMacOSX()) {
            try {
                System.loadLibrary("Dock");
                hasDock = true;
            }
            catch (UnsatisfiedLinkError err) {
                ErrorService.error(err, "java.library.path=" + System.getProperty("java.library.path") + "\n\n" + "trace dependencies=" + MacOSXUtils.traceLibraryDependencies("libDock.jnilib"));
            }
        }
        HAS_DOCK = hasDock;
    }

    public static enum AttentionType {
        CRITICAL(0),
        INFORMATIONAL(10);

        private final int type;

        private AttentionType(int type) {
            this.type = type;
        }
    }
}

