/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.dock;

import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.matchers.Matcher;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadState;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.ui.swing.dock.DockIcon;
import org.limewire.ui.swing.dock.DockIconFactory;
import org.limewire.ui.swing.dock.DockIconMacOSXImpl;
import org.limewire.ui.swing.dock.DockIconNoOpImpl;
import org.limewire.ui.swing.downloads.DownloadMediator;
import org.limewire.util.OSUtils;

@Singleton
public class DockIconFactoryImpl
implements DockIconFactory {
    private final ServiceRegistry registry;
    private final DownloadMediator downloadMediator;
    private DockIcon dockIcon;

    @Inject
    public DockIconFactoryImpl(ServiceRegistry registry, DownloadMediator downloadMediator) {
        this.registry = registry;
        this.downloadMediator = downloadMediator;
    }

    @Override
    public DockIcon createDockIcon() {
        if (this.dockIcon == null) {
            if (OSUtils.isMacOSX()) {
                this.dockIcon = new DockIconMacOSXImpl();
                ((DockIconMacOSXImpl)this.dockIcon).register(this.registry);
                this.registry.start("UIHack");
                this.setupListener();
            } else {
                this.dockIcon = new DockIconNoOpImpl();
            }
        }
        return this.dockIcon;
    }

    private void setupListener() {
        final FilterList<DownloadItem> list = GlazedListsFactory.filterList(this.downloadMediator.getDownloadList(), new DownloadCountListener());
        list.addListEventListener(new ListEventListener<DownloadItem>(){

            @Override
            public void listChanged(ListEvent<DownloadItem> listChanges) {
                DockIconFactoryImpl.this.dockIcon.draw(list.size());
            }
        });
    }

    private class DownloadCountListener
    implements Matcher<DownloadItem> {
        private DownloadCountListener() {
        }

        @Override
        public boolean matches(DownloadItem item) {
            if (item == null) {
                return false;
            }
            DownloadState state = item.getState();
            return state != DownloadState.CANCELLED && state != DownloadState.ERROR && !state.isFinished();
        }
    }
}

