/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.dock;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import org.limewire.lifecycle.Asynchronous;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.ui.swing.dock.Dock;
import org.limewire.ui.swing.dock.DockIcon;

class DockIconMacOSXImpl
implements DockIcon {
    private static final int MAX_NUMBER = 999999;
    private static final int MIN_WnH = 42;
    private final Color FROM = new Color(224, 0, 0);
    private final Color TO = new Color(192, 0, 0);
    private final Font FONT = new Font("Lucida Grande", 1, 24);
    private int complete = 0;

    DockIconMacOSXImpl() {
    }

    void register(ServiceRegistry registry) {
        registry.register(new Service(){

            @Override
            public void start() {
            }

            @Override
            @Asynchronous(daemon=false)
            public void stop() {
                Dock.restoreDockTileImage();
            }

            @Override
            public void initialize() {
            }

            @Override
            public String getServiceName() {
                return "Dock cleanup";
            }
        }).in("UIHack");
    }

    @Override
    public int getIconWidth() {
        return 128;
    }

    @Override
    public int getIconHeight() {
        return 128;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(int complete) {
        Object object = Dock.getDockLock();
        synchronized (object) {
            if (complete != this.complete) {
                this.complete = complete;
                Dock.restoreDockTileImage();
                if (complete > 0) {
                    Dock.setDockTileOverlayImage(this);
                }
            }
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        String value = Integer.toString(Math.min(this.complete, 999999));
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setFont(this.FONT);
        FontMetrics fm = g2.getFontMetrics();
        int valueWidth = fm.stringWidth(value);
        int width = 42;
        if (value.length() > 2) {
            width = Math.max(valueWidth + 16, width);
        }
        RoundRectangle2D.Float ellipse = new RoundRectangle2D.Float(x + 128 - width - 5, y + 128 - 55, width, 42.0f, 42.0f, 42.0f);
        g2.setStroke(new BasicStroke(1.5f));
        g2.setPaint(new GradientPaint(0.0f, 0.0f, this.FROM, ellipse.width, ellipse.height, this.TO));
        g2.fill(ellipse);
        g2.setPaint(Color.black);
        g2.draw(ellipse);
        g2.setPaint(Color.white);
        g2.drawString(value, ellipse.x + (ellipse.width - (float)valueWidth) / 2.0f, ellipse.y + (float)fm.getHeight());
    }
}

