/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.downloads.table;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.awt.Component;
import java.awt.Point;
import java.util.List;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.ui.swing.downloads.table.DownloadTable;
import org.limewire.ui.swing.downloads.table.DownloadTableMenuFactory;
import org.limewire.ui.swing.table.TablePopupHandler;

public class DownloadPopupHandler
implements TablePopupHandler {
    private final DownloadTable table;
    private final DownloadTableMenuFactory menuFactory;

    @Inject
    public DownloadPopupHandler(@Assisted DownloadTable table, DownloadTableMenuFactory menuFactory) {
        this.table = table;
        this.menuFactory = menuFactory;
    }

    @Override
    public boolean isPopupShowing(int row) {
        return false;
    }

    @Override
    public void maybeShowPopup(Component component, int x, int y) {
        this.adjustTableSelection(x, y);
        this.showMenu(component, x, y);
    }

    private void adjustTableSelection(int x, int y) {
        int popupRow = this.table.rowAtPoint(new Point(x, y));
        DownloadItem selectedItem = this.table.getDownloadItem(popupRow);
        if (selectedItem == null) {
            return;
        }
        List<DownloadItem> selectedItems = this.table.getSelectedItems();
        if (selectedItems.size() <= 1 || !selectedItems.contains(selectedItem)) {
            selectedItems.clear();
            this.table.setRowSelectionInterval(popupRow, popupRow);
        }
    }

    private void showMenu(Component component, int x, int y) {
        List<DownloadItem> selectedItems = this.table.getSelectedItems();
        if (selectedItems.size() == 1 && selectedItems.get(0).getDownloadItemType() == DownloadItem.DownloadItemType.ANTIVIRUS) {
            return;
        }
        this.menuFactory.create(this.table).show(component, x, y);
    }
}

