/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.chat;

import org.limewire.friend.api.ChatState;
import org.limewire.friend.api.MessageReader;
import org.limewire.listener.EventBroadcaster;
import org.limewire.ui.swing.friends.chat.ChatFriend;
import org.limewire.ui.swing.friends.chat.ChatMessageEvent;
import org.limewire.ui.swing.friends.chat.ChatStateEvent;
import org.limewire.ui.swing.friends.chat.ErrorMessage;
import org.limewire.ui.swing.friends.chat.Message;
import org.limewire.ui.swing.friends.chat.MessageTextImpl;

class MessageReaderImpl
implements MessageReader {
    private final ChatFriend chatFriend;
    private final EventBroadcaster<ChatMessageEvent> messageList;
    private final EventBroadcaster<ChatStateEvent> chatStateList;

    MessageReaderImpl(ChatFriend chatFriend, EventBroadcaster<ChatMessageEvent> messageList, EventBroadcaster<ChatStateEvent> chatStateList) {
        this.chatFriend = chatFriend;
        this.messageList = messageList;
        this.chatStateList = chatStateList;
    }

    @Override
    public void readMessage(String message) {
        if (message != null) {
            Message msg = this.newMessage(message, Message.Type.RECEIVED);
            this.messageList.broadcast(new ChatMessageEvent(msg));
        }
    }

    private Message newMessage(String message, Message.Type type) {
        return new MessageTextImpl(this.chatFriend.getName(), this.chatFriend.getID(), type, message);
    }

    @Override
    public void newChatState(ChatState chatState) {
        this.chatStateList.broadcast(new ChatStateEvent(this.chatFriend.getID(), chatState));
    }

    @Override
    public void error(String errorMessage) {
        ErrorMessage errMsg = new ErrorMessage(this.chatFriend.getID(), errorMessage, Message.Type.SERVER);
        this.messageList.broadcast(new ChatMessageEvent(errMsg));
    }
}

