/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.navigator;

import org.limewire.core.api.Category;
import org.limewire.core.api.library.LocalFileList;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.ui.swing.util.I18n;

public class LibraryNavItem {
    private final NavType navType;
    private final LocalFileList localFileList;
    private final SharedFileList sharedFileList;
    private Category selectedCategory;
    private String filterText;

    public LibraryNavItem(LocalFileList localFileList) {
        this.localFileList = localFileList;
        if (localFileList instanceof SharedFileList) {
            this.sharedFileList = (SharedFileList)localFileList;
            this.navType = this.sharedFileList.isPublic() ? NavType.PUBLIC_SHARED : NavType.LIST;
        } else {
            this.sharedFileList = null;
            this.navType = NavType.LIBRARY;
        }
        this.selectedCategory = null;
        this.filterText = "";
    }

    public LocalFileList getLocalFileList() {
        return this.localFileList;
    }

    public int getId() {
        return this.sharedFileList != null ? this.sharedFileList.getId() : -1;
    }

    public Category getSelectedCategory() {
        return this.selectedCategory;
    }

    public void setSelectedCategory(Category selectedCategory) {
        this.selectedCategory = selectedCategory;
    }

    public String getFilteredText() {
        return this.filterText;
    }

    public void setFilteredText(String filteredText) {
        this.filterText = filteredText;
    }

    public String getDisplayText() {
        switch (this.navType) {
            case LIST: {
                return this.sharedFileList.getCollectionName();
            }
            case LIBRARY: {
                return I18n.tr("Library");
            }
            case PUBLIC_SHARED: {
                return I18n.tr("Public Shared");
            }
        }
        throw new IllegalStateException("unknown type: " + (Object)((Object)this.navType));
    }

    public NavType getType() {
        return this.navType;
    }

    public boolean isShared() {
        if (this.getType() == NavType.PUBLIC_SHARED) {
            return true;
        }
        if (this.sharedFileList != null) {
            return this.sharedFileList.getFriendIds().size() > 0;
        }
        return false;
    }

    public static enum NavType {
        LIBRARY,
        PUBLIC_SHARED,
        LIST;

    }
}

