/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.mainframe;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JPanel;
import org.limewire.core.api.Application;
import org.limewire.core.settings.LWSSettings;
import org.limewire.ui.swing.browser.Browser;
import org.limewire.ui.swing.browser.HistoryEntry;
import org.limewire.ui.swing.nav.Navigator;
import org.mozilla.browser.MozillaAutomation;
import org.mozilla.browser.MozillaInitialization;
import org.mozilla.browser.MozillaPanel;

@Singleton
public class StorePanel
extends JPanel {
    private final Browser browser;
    private final Application application;

    @Inject
    public StorePanel(Application application, Navigator navigator) {
        this.application = application;
        this.browser = new Browser(MozillaPanel.VisibilityMode.FORCED_HIDDEN, MozillaPanel.VisibilityMode.FORCED_HIDDEN, MozillaPanel.VisibilityMode.DEFAULT);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.browser, gbc);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (MozillaInitialization.isInitialized()) {
                    MozillaAutomation.executeJavascript(StorePanel.this.browser, "clientNavigateAway();");
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
                if (MozillaInitialization.isInitialized()) {
                    MozillaAutomation.executeJavascript(StorePanel.this.browser, "clientNavigateTo();");
                }
            }
        });
    }

    public Iterable<HistoryEntry> getHistory(AtomicReference<Integer> currentPosition) {
        return this.browser.getHistory(10, currentPosition);
    }

    public void loadHistoryEntry(HistoryEntry entry) {
        this.browser.loadHistoryEntry(entry);
    }

    public void loadCurrentUrl() {
        String url = this.browser.getUrl();
        if (url == null || url.length() == 0) {
            this.loadDefaultUrl();
        }
    }

    public void loadDefaultUrl() {
        String url = "http://" + LWSSettings.LWS_AUTHENTICATION_HOSTNAME.get();
        if (LWSSettings.LWS_AUTHENTICATION_PORT.get() != 80) {
            url = url + ":" + LWSSettings.LWS_AUTHENTICATION_PORT.get();
        }
        url = url + LWSSettings.LWS_AUTHENTICATION_PATH.get();
        this.load(url);
    }

    public void load(String url) {
        url = this.application.addClientInfoToUrl(url);
        MozillaAutomation.blockingLoad(this.browser, "about:blank");
        this.browser.load(url + "&isClient=true");
    }
}

