/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.menu;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.jdesktop.application.Resource;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.ui.swing.action.DelayedMenuItemCreator;
import org.limewire.ui.swing.mainframe.StoreMediator;
import org.limewire.ui.swing.menu.FileMenu;
import org.limewire.ui.swing.menu.FriendsMenu;
import org.limewire.ui.swing.menu.HelpMenu;
import org.limewire.ui.swing.menu.StoreMenu;
import org.limewire.ui.swing.menu.ToolsMenu;
import org.limewire.ui.swing.menu.ViewMenu;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.GuiUtils;

public class LimeMenuBar
extends JMenuBar {
    @Resource
    private Color backgroundColor;
    private final MenuListener menuListener;

    @Inject
    LimeMenuBar(FileMenu fileMenu, FriendsMenu friendMenu, ViewMenu viewMenu, HelpMenu helpMenu, ToolsMenu toolsMenu, final Provider<StoreMenu> storeMenuProvider) {
        GuiUtils.assignResources(this);
        this.setBackground(this.backgroundColor);
        this.menuListener = new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
                ((JMenu)e.getSource()).removeAll();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                ((JMenu)e.getSource()).removeAll();
            }

            @Override
            public void menuSelected(MenuEvent e) {
                ((DelayedMenuItemCreator)e.getSource()).createMenuItems();
            }
        };
        this.addMenu(0, fileMenu);
        this.addMenu(1, viewMenu);
        this.addMenu(2, friendMenu);
        this.addMenu(3, toolsMenu);
        if (StoreMediator.canShowStoreMenu()) {
            this.addMenu(4, storeMenuProvider.get());
        } else {
            SwingUiSettings.SHOW_STORE_COMPONENTS.addSettingListener(new SettingListener(){

                @Override
                public void settingChanged(SettingEvent evt) {
                    if (StoreMediator.canShowStoreMenu()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LimeMenuBar.this.addMenu(4, (JMenu)storeMenuProvider.get());
                            }
                        });
                    }
                }
            });
        }
        this.addMenu(this.getMenuCount(), helpMenu);
    }

    private void addMenu(int idx, JMenu menu) {
        this.add((Component)menu, idx);
        menu.setBackground(this.backgroundColor);
        menu.addMenuListener(this.menuListener);
    }
}

