/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;
import org.limewire.core.api.Category;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.components.MultiLineLabel;
import org.limewire.ui.swing.components.decorators.ButtonDecorator;
import org.limewire.ui.swing.components.decorators.TableDecorator;
import org.limewire.ui.swing.options.actions.OKDialogAction;
import org.limewire.ui.swing.table.DefaultLimeTableCellRenderer;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.IconManager;
import org.limewire.util.OSUtils;

public class ExtensionClassificationPanel
extends JPanel {
    private static final Category[] ALL_CATEGORIES = Category.values();
    private static final String TABLE_VIEW = "TABLE_VIEW";
    private static final String OTHER_VIEW = "OTHER_VIEW";
    private final CategoryManager categoryManager;
    private final IconManager iconManager;
    private final ButtonDecorator buttonDecorator;
    private final JXTable table;
    private final JPanel contentPanel;
    private final CardLayout contentSwitcher;
    private Category[] currentCategories = null;
    private final JPanel switchPanel;

    @Inject
    public ExtensionClassificationPanel(CategoryManager categoryManager, IconManager iconManager, TableDecorator tableDecorator, ButtonDecorator buttonDecorator) {
        super(new BorderLayout());
        this.categoryManager = categoryManager;
        this.iconManager = iconManager;
        this.buttonDecorator = buttonDecorator;
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setOpaque(false);
        this.add((Component)new JLabel("<html>" + I18n.tr("Below are the file extensions LimeWire knows about and how they are classified throughout the program") + "</html>"), "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setOpaque(false);
        this.switchPanel = new JPanel(new MigLayout("insets 10, gap 5"));
        this.switchPanel.setOpaque(false);
        centerPanel.add((Component)this.switchPanel, "North");
        this.table = new JXTable();
        tableDecorator.decorate(this.table);
        this.table.setShowGrid(false, false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        this.table.setDefaultRenderer(Object.class, new DefaultLimeTableCellRenderer());
        JScrollPane scrollPane = new JScrollPane(this.table, 20, 30);
        scrollPane.setOpaque(false);
        this.contentSwitcher = new CardLayout();
        this.contentPanel = new JPanel(this.contentSwitcher);
        this.contentPanel.setOpaque(false);
        this.contentPanel.add((Component)scrollPane, TABLE_VIEW);
        JPanel otherPanel = new JPanel(new GridBagLayout());
        otherPanel.setOpaque(false);
        MultiLineLabel otherLabel = new MultiLineLabel(I18n.tr("File types that LimeWire doesn't know about are classified as \"Other\". Add these files to a List by dragging them, or when adding a folder, click \"Advanced\" and choose specific file extensions"), 450);
        otherLabel.setOpaque(false);
        otherPanel.add(otherLabel);
        this.contentPanel.add((Component)otherPanel, OTHER_VIEW);
        centerPanel.add((Component)this.contentPanel, "Center");
        this.add((Component)centerPanel, "Center");
    }

    private TableModel createTableModel(Category ... categories) {
        AbstractCollection extensions = new HashSet<String>();
        for (Category category : categories) {
            extensions.addAll(this.categoryManager.getExtensionsForCategory(category));
        }
        ArrayList sortedList = new ArrayList(extensions);
        Collections.sort(sortedList);
        extensions = sortedList;
        ArrayList<String> headingList = new ArrayList<String>();
        headingList.add("");
        headingList.add(I18n.tr("Extension"));
        if (categories.length > 1) {
            headingList.add(I18n.tr("Category"));
        }
        if (OSUtils.isWindows()) {
            headingList.add(I18n.tr("Type"));
        }
        Object[][] data = new Object[extensions.size()][headingList.size()];
        int y = 0;
        for (String ext : extensions) {
            int x = 0;
            Icon icon = this.iconManager.getIconForExtension(ext);
            data[y][x++] = icon;
            data[y][x++] = ext;
            if (categories.length > 1) {
                data[y][x++] = I18n.tr(this.categoryManager.getCategoryForExtension(ext).getSingularName());
            }
            if (OSUtils.isWindows() && icon != null && !icon.toString().startsWith("file:/")) {
                data[y][x++] = icon.toString();
            }
            ++y;
        }
        return new DefaultTableModel(data, headingList.toArray()){

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == 0) {
                    return Icon.class;
                }
                return String.class;
            }
        };
    }

    public void switchCategory(Category category) {
        if (category == null) {
            this.switchCategory(ALL_CATEGORIES);
        } else {
            this.switchCategory(new Category[]{category});
        }
        this.updateSelection(category);
    }

    private void switchCategory(Category ... categories) {
        if (categories == this.currentCategories) {
            return;
        }
        if (categories.length == 1 && categories[0] == Category.OTHER) {
            this.contentSwitcher.show(this.contentPanel, OTHER_VIEW);
        } else {
            this.contentSwitcher.show(this.contentPanel, TABLE_VIEW);
        }
        this.currentCategories = categories;
        TableModel model = this.createTableModel(this.currentCategories);
        this.table.setModel(model);
        TableColumnExt iconColumn = this.table.getColumnExt(model.getColumnName(0));
        iconColumn.setResizable(false);
        iconColumn.setMinWidth(16);
        iconColumn.setMaxWidth(16);
        iconColumn.setWidth(16);
        iconColumn.setComparator(new Comparator<ImageIcon>(){

            @Override
            public int compare(ImageIcon o1, ImageIcon o2) {
                return o1.getImage().toString().compareTo(o2.getImage().toString());
            }
        });
    }

    private void updateSelection(JButton button) {
        button.setSelected(true);
        for (Component comp : this.switchPanel.getComponents()) {
            if (!(comp instanceof JButton) || button == comp) continue;
            ((JButton)comp).setSelected(false);
        }
    }

    private void updateSelection(Category category) {
        for (Component comp : this.switchPanel.getComponents()) {
            if (!(comp instanceof JButton)) continue;
            JButton button = (JButton)comp;
            Category[] categoriesForSwitch = ((CategorySwitchAction)button.getAction()).getCategoriesForSwitch();
            if (category == null) {
                button.setSelected(categoriesForSwitch.length > 1);
                continue;
            }
            button.setSelected(categoriesForSwitch.length != 0 && categoriesForSwitch[0] == category);
        }
    }

    private JButton createSelectionButton(Action action) {
        JXButton button = new JXButton(action);
        button.setModel(new JToggleButton.ToggleButtonModel());
        this.buttonDecorator.decorateLinkButton(button);
        return button;
    }

    public void init() {
        if (this.currentCategories == null) {
            this.switchCategory(ALL_CATEGORIES);
        }
        this.switchPanel.removeAll();
        this.switchPanel.invalidate();
        this.switchPanel.add(new JLabel(I18n.tr("Show:")));
        JButton allButton = this.createSelectionButton(new CategorySwitchAction(I18n.tr("All"), ALL_CATEGORIES));
        allButton.setSelected(this.currentCategories == ALL_CATEGORIES);
        this.switchPanel.add(allButton);
        for (Category category : ALL_CATEGORIES) {
            JButton categoryButton = this.createSelectionButton(new CategorySwitchAction(category));
            categoryButton.setSelected(this.currentCategories.length == 1 && category == this.currentCategories[0]);
            this.switchPanel.add(categoryButton);
        }
    }

    public void showDialogue() {
        this.init();
        JDialog dialog = FocusJOptionPane.createDialog(I18n.tr("File extension Classification"), null, this);
        JPanel buttonPanel = new JPanel(new MigLayout("insets 0 0 10 10, gap 4, fill"));
        buttonPanel.setOpaque(false);
        buttonPanel.add((Component)new JButton(new OKDialogAction()), "tag ok");
        dialog.getContentPane().add((Component)buttonPanel, "South");
        dialog.pack();
        this.table.requestFocusInWindow();
        dialog.setVisible(true);
    }

    private class CategorySwitchAction
    extends AbstractAction {
        private final Category[] categoriesForSwitch;

        public CategorySwitchAction(String name, Category ... categoriesForSwitch) {
            super(name);
            this.categoriesForSwitch = categoriesForSwitch;
        }

        public CategorySwitchAction(Category ... categoriesForSwitch) {
            super(I18n.tr(categoriesForSwitch[0].getPluralName()));
            this.categoriesForSwitch = categoriesForSwitch;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExtensionClassificationPanel.this.switchCategory(this.categoriesForSwitch);
            ExtensionClassificationPanel.this.updateSelection((JButton)e.getSource());
        }

        public Category[] getCategoriesForSwitch() {
            return this.categoriesForSwitch;
        }
    }
}

