/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.miginfocom.swing.MigLayout;
import org.limewire.bittorrent.TorrentManager;
import org.limewire.bittorrent.TorrentManagerSettings;
import org.limewire.bittorrent.TorrentSettingsAnnotation;
import org.limewire.core.api.network.NetworkManager;
import org.limewire.core.settings.BittorrentSettings;
import org.limewire.core.settings.ConnectionSettings;
import org.limewire.core.settings.NetworkSettings;
import org.limewire.ui.swing.components.EmbeddedComponentLabel;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.components.MultiLineLabel;
import org.limewire.ui.swing.components.NumericTextField;
import org.limewire.ui.swing.options.OptionPanel;
import org.limewire.ui.swing.util.BackgroundExecutorService;
import org.limewire.ui.swing.util.I18n;

public class ListeningPortsOptionPanel
extends OptionPanel {
    private final NetworkManager networkManager;
    private final Provider<TorrentManager> torrentManager;
    private final TorrentListeningPortsOptionPanel torrentListeningPorts;
    private final GnutellaListeningPortsOptionPanel gnutellaListeningPorts;
    @TorrentSettingsAnnotation
    private final TorrentManagerSettings torrentSettings;

    @Inject
    public ListeningPortsOptionPanel(NetworkManager networkManager, Provider<TorrentManager> torrentManager, @TorrentSettingsAnnotation TorrentManagerSettings torrentSettings) {
        this.setLayout(new MigLayout("insets 15, fillx"));
        this.setOpaque(false);
        this.networkManager = networkManager;
        this.torrentManager = torrentManager;
        this.torrentSettings = torrentSettings;
        this.gnutellaListeningPorts = new GnutellaListeningPortsOptionPanel();
        this.torrentListeningPorts = new TorrentListeningPortsOptionPanel();
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder(""));
        p.setLayout(new MigLayout("fillx"));
        p.setOpaque(false);
        p.add((Component)new MultiLineLabel(I18n.tr("You can set the local network port that listens for incoming connections. This port may be changed in case of conflict with another program or if a specific port number is required for direct incoming connections by your firewall. You must also configure your router when choosing \"manual port forward\" or \"do nothing\""), 440), "pad 0, growx, wrap");
        p.add((Component)this.gnutellaListeningPorts, "gaptop 10, growx, wrap");
        p.add((Component)this.torrentListeningPorts, "gaptop 10, growx, wrap");
        this.add((Component)p, "pushx, growx");
    }

    @Override
    boolean applyOptions() {
        return this.gnutellaListeningPorts.applyOptions() || this.torrentListeningPorts.applyOptions();
    }

    @Override
    boolean hasChanged() {
        return this.gnutellaListeningPorts.hasChanged() || this.torrentListeningPorts.hasChanged();
    }

    @Override
    public void initOptions() {
        this.gnutellaListeningPorts.initOptions();
        this.torrentListeningPorts.initOptions();
    }

    private class TorrentListeningPortsOptionPanel
    extends OptionPanel {
        private final JRadioButton torrentPlugAndPlayRadioButton;
        private final JRadioButton torrentDoNothingRadioButton;
        private final JComponent torrentPortController;
        private final NumericTextField torrentStartPortField;
        private final NumericTextField torrentEndPortField;

        public TorrentListeningPortsOptionPanel() {
            this.setLayout(new MigLayout("insets 0, nogrid"));
            this.setOpaque(false);
            this.torrentStartPortField = new NumericTextField(5, 1, 65535);
            this.torrentEndPortField = new NumericTextField(5, 1, 65535);
            this.torrentPortController = new EmbeddedComponentLabel(I18n.tr("BitTorrent ports: {c} to {c}"), this.torrentStartPortField, this.torrentEndPortField);
            this.add((Component)this.torrentPortController, "wrap");
            this.torrentPlugAndPlayRadioButton = new JRadioButton(I18n.tr("Use Universal Plug n' Play (Recommended)"));
            this.torrentDoNothingRadioButton = new JRadioButton(I18n.tr("Do Nothing"));
            this.torrentPlugAndPlayRadioButton.setOpaque(false);
            this.torrentDoNothingRadioButton.setOpaque(false);
            ButtonGroup torrentButtonGroup = new ButtonGroup();
            torrentButtonGroup.add(this.torrentPlugAndPlayRadioButton);
            torrentButtonGroup.add(this.torrentDoNothingRadioButton);
            this.add((Component)this.torrentPlugAndPlayRadioButton, "wrap");
            this.add((Component)this.torrentDoNothingRadioButton, "wrap");
        }

        @Override
        boolean applyOptions() {
            int torrentEndPort;
            int torrentStartPort = this.torrentStartPortField.getValue(BittorrentSettings.LIBTORRENT_LISTEN_START_PORT.getValue());
            if (torrentStartPort > (torrentEndPort = this.torrentEndPortField.getValue(BittorrentSettings.LIBTORRENT_LISTEN_END_PORT.getValue()))) {
                int temp = torrentStartPort;
                torrentStartPort = torrentEndPort;
                torrentEndPort = temp;
            }
            BittorrentSettings.LIBTORRENT_LISTEN_START_PORT.setValue(torrentStartPort);
            BittorrentSettings.LIBTORRENT_LISTEN_END_PORT.setValue(torrentEndPort);
            BittorrentSettings.TORRENT_USE_UPNP.setValue(this.torrentPlugAndPlayRadioButton.isSelected());
            if (((TorrentManager)ListeningPortsOptionPanel.this.torrentManager.get()).isInitialized() && ((TorrentManager)ListeningPortsOptionPanel.this.torrentManager.get()).isValid()) {
                BackgroundExecutorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        ((TorrentManager)ListeningPortsOptionPanel.this.torrentManager.get()).setTorrentManagerSettings(ListeningPortsOptionPanel.this.torrentSettings);
                        if (BittorrentSettings.TORRENT_USE_UPNP.getValue()) {
                            ((TorrentManager)ListeningPortsOptionPanel.this.torrentManager.get()).startUPnP();
                        } else {
                            ((TorrentManager)ListeningPortsOptionPanel.this.torrentManager.get()).stopUPnP();
                        }
                    }
                });
            }
            return false;
        }

        @Override
        boolean hasChanged() {
            return this.torrentStartPortField.getValue(BittorrentSettings.LIBTORRENT_LISTEN_START_PORT.getValue()) != BittorrentSettings.LIBTORRENT_LISTEN_START_PORT.getValue() || this.torrentEndPortField.getValue(BittorrentSettings.LIBTORRENT_LISTEN_END_PORT.getValue()) != BittorrentSettings.LIBTORRENT_LISTEN_END_PORT.getValue() || this.torrentPlugAndPlayRadioButton.isSelected() != BittorrentSettings.TORRENT_USE_UPNP.getValue();
        }

        @Override
        public void initOptions() {
            this.torrentStartPortField.setValue(BittorrentSettings.LIBTORRENT_LISTEN_START_PORT.getValue());
            this.torrentEndPortField.setValue(BittorrentSettings.LIBTORRENT_LISTEN_END_PORT.getValue());
            this.torrentPlugAndPlayRadioButton.setSelected(BittorrentSettings.TORRENT_USE_UPNP.getValue());
            this.torrentDoNothingRadioButton.setSelected(!BittorrentSettings.TORRENT_USE_UPNP.getValue());
        }
    }

    private class GnutellaListeningPortsOptionPanel
    extends OptionPanel {
        private final JRadioButton gnutellaPlugAndPlayRadioButton;
        private final JRadioButton gnutellaPortForwardRadioButton;
        private final NumericTextField gnutellaForcePortTextField;
        private final JLabel gnutellaManualConfigurationWarning;
        private final JRadioButton gnutellaDoNothingRadioButton;
        private final NumericTextField gnutellaPortField;
        private int gnutellaPort;

        public GnutellaListeningPortsOptionPanel() {
            this.setLayout(new MigLayout("insets 0, nogrid"));
            this.setOpaque(false);
            this.add((Component)new JLabel(I18n.tr("Gnutella port:")), "split");
            this.gnutellaPortField = new NumericTextField(5, 1, 65535);
            this.add((Component)this.gnutellaPortField, "wrap");
            this.gnutellaPlugAndPlayRadioButton = new JRadioButton(I18n.tr("Use Universal Plug n' Play (Recommended)"));
            this.gnutellaPortForwardRadioButton = new JRadioButton(I18n.tr("Manual Port Forward:"));
            this.gnutellaDoNothingRadioButton = new JRadioButton(I18n.tr("Do Nothing"));
            this.gnutellaPlugAndPlayRadioButton.setOpaque(false);
            this.gnutellaPortForwardRadioButton.setOpaque(false);
            this.gnutellaDoNothingRadioButton.setOpaque(false);
            ButtonGroup gnutellaButtonGroup = new ButtonGroup();
            gnutellaButtonGroup.add(this.gnutellaPlugAndPlayRadioButton);
            gnutellaButtonGroup.add(this.gnutellaPortForwardRadioButton);
            gnutellaButtonGroup.add(this.gnutellaDoNothingRadioButton);
            this.add((Component)this.gnutellaPlugAndPlayRadioButton, "split, wrap");
            this.add((Component)this.gnutellaPortForwardRadioButton, "split");
            this.gnutellaForcePortTextField = new NumericTextField(5, 1, 65535);
            this.gnutellaManualConfigurationWarning = new JLabel(I18n.tr("* You must also configure your router"));
            this.gnutellaManualConfigurationWarning.setVisible(false);
            this.add((Component)this.gnutellaForcePortTextField, "wrap");
            this.add((Component)this.gnutellaManualConfigurationWarning, "gapleft 85, wrap, hidemode 2");
            this.add((Component)this.gnutellaDoNothingRadioButton, "split, wrap");
            this.gnutellaPortForwardRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    GnutellaListeningPortsOptionPanel.this.updateTextField();
                }
            });
        }

        @Override
        boolean applyOptions() {
            int newGnutellaPort = this.gnutellaPortField.getValue(this.gnutellaPort);
            if (newGnutellaPort != this.gnutellaPort) {
                try {
                    NetworkSettings.PORT.setValue(newGnutellaPort);
                    ListeningPortsOptionPanel.this.networkManager.setListeningPort(newGnutellaPort);
                    this.gnutellaPort = newGnutellaPort;
                    ListeningPortsOptionPanel.this.networkManager.portChanged();
                }
                catch (IOException ioe) {
                    FocusJOptionPane.showMessageDialog(ListeningPortsOptionPanel.this, I18n.tr("The port chosen {0}, is already in use.", newGnutellaPort), I18n.tr("Network Port Error"), 0);
                    NetworkSettings.PORT.setValue(this.gnutellaPort);
                    this.gnutellaPortField.setValue(this.gnutellaPort);
                }
            }
            boolean restart = false;
            boolean oldUPNP = ConnectionSettings.DISABLE_UPNP.getValue();
            final int oldForcedPort = ConnectionSettings.FORCED_PORT.getValue();
            final boolean oldForce = ConnectionSettings.FORCE_IP_ADDRESS.getValue();
            if (this.gnutellaPlugAndPlayRadioButton.isSelected()) {
                if (!ConnectionSettings.UPNP_IN_USE.getValue()) {
                    ConnectionSettings.FORCE_IP_ADDRESS.setValue(false);
                }
                ConnectionSettings.DISABLE_UPNP.setValue(false);
                if (oldUPNP || oldForce) {
                    restart = true;
                }
            } else if (this.gnutellaDoNothingRadioButton.isSelected()) {
                ConnectionSettings.FORCE_IP_ADDRESS.setValue(false);
                ConnectionSettings.DISABLE_UPNP.setValue(true);
            } else {
                int gnutellaForcedPort = this.gnutellaForcePortTextField.getValue(oldForcedPort);
                ConnectionSettings.DISABLE_UPNP.setValue(false);
                ConnectionSettings.FORCE_IP_ADDRESS.setValue(true);
                ConnectionSettings.UPNP_IN_USE.setValue(false);
                ConnectionSettings.FORCED_PORT.setValue(gnutellaForcedPort);
            }
            final boolean newForce = ConnectionSettings.FORCE_IP_ADDRESS.getValue();
            final int newForcedPort = ConnectionSettings.FORCED_PORT.getValue();
            BackgroundExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    if (oldForce != newForce) {
                        ListeningPortsOptionPanel.this.networkManager.addressChanged();
                    }
                    if (newForce && oldForcedPort != newForcedPort) {
                        ListeningPortsOptionPanel.this.networkManager.portChanged();
                    }
                }
            });
            return restart;
        }

        @Override
        boolean hasChanged() {
            if (ConnectionSettings.FORCE_IP_ADDRESS.getValue() && !ConnectionSettings.UPNP_IN_USE.getValue() ? !this.gnutellaPortForwardRadioButton.isSelected() : (ConnectionSettings.DISABLE_UPNP.getValue() ? !this.gnutellaDoNothingRadioButton.isSelected() : !this.gnutellaPlugAndPlayRadioButton.isSelected())) {
                return true;
            }
            int forcedPortSetting = ConnectionSettings.FORCED_PORT.getValue();
            int portSetting = NetworkSettings.PORT.getValue();
            return portSetting != this.gnutellaPortField.getValue(portSetting) || this.gnutellaPortForwardRadioButton.isSelected() && this.gnutellaForcePortTextField.getValue(forcedPortSetting) != forcedPortSetting;
        }

        @Override
        public void initOptions() {
            this.gnutellaPort = NetworkSettings.PORT.getValue();
            this.gnutellaPortField.setValue(this.gnutellaPort);
            if (ConnectionSettings.FORCE_IP_ADDRESS.getValue() && !ConnectionSettings.UPNP_IN_USE.getValue()) {
                this.gnutellaPortForwardRadioButton.setSelected(true);
            } else if (ConnectionSettings.DISABLE_UPNP.getValue()) {
                this.gnutellaDoNothingRadioButton.setSelected(true);
            } else {
                this.gnutellaPlugAndPlayRadioButton.setSelected(true);
            }
            this.gnutellaForcePortTextField.setValue(ConnectionSettings.FORCED_PORT.getValue());
            this.updateTextField();
        }

        private void updateTextField() {
            this.gnutellaForcePortTextField.setEnabled(this.gnutellaPortForwardRadioButton.isSelected());
            this.gnutellaForcePortTextField.setEditable(this.gnutellaPortForwardRadioButton.isSelected());
            this.gnutellaManualConfigurationWarning.setVisible(this.gnutellaPortForwardRadioButton.isSelected());
        }
    }
}

