/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.painter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.painter.RectanglePainter;
import org.limewire.ui.swing.components.PromptTextField;
import org.limewire.ui.swing.util.GuiUtils;

public class FilterPainter<T>
extends RectanglePainter<T>
implements DocumentListener {
    @Resource
    private Color fillColor;
    @Resource
    private Icon activeResetIcon;
    @Resource
    private Icon inactiveResetIcon;
    private final MouseAdapter resetListener;
    private Cursor defaultCursor;
    private Icon resetIcon;
    private boolean showIcon;

    public FilterPainter(int arcWidth, int arcHeight) {
        GuiUtils.assignResources(this);
        this.resetListener = new ResetMouseListener();
        this.setRounded(true);
        this.setFillPaint(Color.WHITE);
        this.setRoundWidth(arcWidth);
        this.setRoundHeight(arcHeight);
        this.setInsets(new Insets(2, 2, 2, 2));
        this.setBorderPaint(null);
        this.setFillVertical(true);
        this.setFillHorizontal(true);
        this.setAntialiasing(true);
        this.setCacheable(true);
        this.setResetIcon(this.inactiveResetIcon);
    }

    public void install(PromptTextField textField) {
        this.defaultCursor = textField.getCursor();
        textField.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 12 + this.resetIcon.getIconWidth()));
        textField.addMouseListener(this.resetListener);
        textField.addMouseMotionListener(this.resetListener);
        textField.getDocument().addDocumentListener(this);
    }

    @Override
    public void doPaint(Graphics2D g, T component, int width, int height) {
        super.doPaint(g, component, width, height);
        if (this.showIcon) {
            Point iconLocation = this.getIconLocation(width, height);
            this.resetIcon.paintIcon((Component)component, g, iconLocation.x, iconLocation.y);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updatePainter(e.getDocument());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updatePainter(e.getDocument());
    }

    private Point getIconLocation(int width, int height) {
        int iconWidth = this.resetIcon.getIconWidth();
        int iconHeight = this.resetIcon.getIconHeight();
        return new Point(width - iconWidth - 6, (height - iconHeight) / 2);
    }

    private boolean isIconLocation(MouseEvent e) {
        Point mouseLocation = e.getPoint();
        Point iconLocation = this.getIconLocation(e.getComponent().getWidth(), e.getComponent().getHeight());
        int iconWidth = this.resetIcon.getIconWidth();
        int iconHeight = this.resetIcon.getIconHeight();
        return mouseLocation.x >= iconLocation.x && mouseLocation.x <= iconLocation.x + iconWidth && mouseLocation.y >= iconLocation.y && mouseLocation.y <= iconLocation.y + iconHeight;
    }

    private void setResetIcon(Icon resetIcon) {
        if (this.resetIcon != resetIcon) {
            this.resetIcon = resetIcon;
            this.setDirty(true);
        }
    }

    private void updatePainter(Document document) {
        this.setFillPaint(document.getLength() == 0 ? Color.WHITE : this.fillColor);
        boolean bl = this.showIcon = document.getLength() != 0;
        if (!this.showIcon) {
            this.setResetIcon(this.inactiveResetIcon);
        }
    }

    private class ResetMouseListener
    extends MouseAdapter {
        private ResetMouseListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JTextField textField = (JTextField)e.getSource();
            if (FilterPainter.this.showIcon) {
                if (FilterPainter.this.isIconLocation(e)) {
                    textField.setCursor(Cursor.getDefaultCursor());
                    FilterPainter.this.setResetIcon(FilterPainter.this.activeResetIcon);
                } else {
                    textField.setCursor(FilterPainter.this.defaultCursor);
                    FilterPainter.this.setResetIcon(FilterPainter.this.inactiveResetIcon);
                }
                textField.repaint();
            } else if (textField.getCursor() != FilterPainter.this.defaultCursor) {
                textField.setCursor(FilterPainter.this.defaultCursor);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (FilterPainter.this.showIcon && FilterPainter.this.isIconLocation(e)) {
                ((JTextField)e.getSource()).setText(null);
            }
        }
    }
}

