/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.painter;

import java.awt.Graphics2D;
import java.awt.Paint;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.painter.AbstractPainter;

public class PopupButtonBackgroundPainter
extends AbstractPainter<JXButton> {
    private final int arcWidth;
    private final int arcHeight;
    private final Paint backgroundPressed;
    private final Paint backgroundRollover;

    public PopupButtonBackgroundPainter(Paint backgroundPressed, Paint backgroundRollover, int arcWidth, int arcHeight) {
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
        this.backgroundPressed = backgroundPressed;
        this.backgroundRollover = backgroundRollover;
        this.setAntialiasing(true);
    }

    @Override
    protected void doPaint(Graphics2D g, JXButton button, int width, int height) {
        if (button.getModel().isPressed() || button.getModel().isSelected()) {
            g.setPaint(this.backgroundPressed);
            g.fillRoundRect(1, 0, width - 2, height - 1, this.arcWidth, this.arcHeight);
        } else if (button.getModel().isRollover() || button.hasFocus()) {
            g.setPaint(this.backgroundRollover);
            g.fillRoundRect(1, 0, width - 2, height - 1, this.arcWidth, this.arcHeight);
        }
    }
}

