/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.properties;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.core.api.library.PropertiableFile;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.core.api.library.SharedFileListManager;
import org.limewire.ui.swing.components.YesNoCheckBoxDialog;
import org.limewire.ui.swing.library.table.RemoveButton;
import org.limewire.ui.swing.properties.FileInfoDialog;
import org.limewire.ui.swing.properties.FileInfoPanel;
import org.limewire.ui.swing.settings.QuestionsHandler;
import org.limewire.ui.swing.table.MouseableTable;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

public class FileInfoSharingPanel
implements FileInfoPanel {
    @Resource
    private Color foreground;
    @Resource
    private Font headerFont;
    @Resource
    private Icon publicIcon;
    @Resource
    private Icon listSharedIcon;
    private final JPanel component;
    private final FileInfoDialog.FileInfoType type;
    private final PropertiableFile propertiableFile;
    private final SharedFileListManager sharedFileListManager;

    public FileInfoSharingPanel(FileInfoDialog.FileInfoType type, PropertiableFile propertiableFile, SharedFileListManager sharedFileListManager) {
        this.type = type;
        this.propertiableFile = propertiableFile;
        this.sharedFileListManager = sharedFileListManager;
        GuiUtils.assignResources(this);
        this.component = new JPanel(new MigLayout("fillx"));
        this.init();
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public void save() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void updatePropertiableFile(PropertiableFile file) {
    }

    private void init() {
        this.component.setOpaque(false);
        switch (this.type) {
            case LOCAL_FILE: {
                if (!(this.propertiableFile instanceof LocalFileItem)) break;
                if (((LocalFileItem)this.propertiableFile).isShareable()) {
                    EventList<SharedFileList> sharedWithList = this.getSharedWithList((LocalFileItem)this.propertiableFile);
                    if (sharedWithList.size() > 0) {
                        this.component.add((Component)this.createHeaderLabel(I18n.tr("Sharing from these lists")), "span, wrap");
                        MouseableTable table = new MouseableTable(new DefaultEventTableModel<SharedFileList>(sharedWithList, new TableFormat<SharedFileList>(){

                            @Override
                            public int getColumnCount() {
                                return 3;
                            }

                            @Override
                            public String getColumnName(int column) {
                                return null;
                            }

                            @Override
                            public Object getColumnValue(SharedFileList baseObject, int column) {
                                switch (column) {
                                    case 0: {
                                        return baseObject.isPublic() ? FileInfoSharingPanel.this.publicIcon : FileInfoSharingPanel.this.listSharedIcon;
                                    }
                                    case 2: {
                                        return baseObject;
                                    }
                                }
                                return baseObject.getCollectionName();
                            }
                        }));
                        table.setShowGrid(false, false);
                        table.setTableHeader(null);
                        table.getColumn(0).setCellRenderer(new IconRenderer());
                        table.getColumn(0).setMinWidth(16);
                        table.getColumn(0).setMaxWidth(16);
                        table.getColumn(0).setWidth(16);
                        JScrollPane scroll = new JScrollPane(table);
                        scroll.setOpaque(false);
                        scroll.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                        TableColumn column = table.getColumn(2);
                        column.setCellRenderer(new RemoveRenderer());
                        column.setCellEditor(new RemoveEditor());
                        column.setMinWidth(16);
                        column.setMaxWidth(16);
                        column.setWidth(16);
                        this.component.add((Component)scroll, "grow, wrap");
                        break;
                    }
                    this.component.add((Component)this.createHeaderLabel(I18n.tr("This file is not shared")), "span, wrap");
                    break;
                }
                this.component.add((Component)this.createHeaderLabel(I18n.tr("This file cannot be shared")), "span, wrap");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventList<SharedFileList> getSharedWithList(LocalFileItem fileItem) {
        BasicEventList<SharedFileList> sharedWith = new BasicEventList<SharedFileList>();
        this.sharedFileListManager.getModel().getReadWriteLock().readLock().lock();
        try {
            for (SharedFileList sharedFileList : this.sharedFileListManager.getModel()) {
                if (!sharedFileList.contains(fileItem.getFile()) || sharedFileList.getFriendIds().size() <= 0) continue;
                sharedWith.add(sharedFileList);
            }
        }
        finally {
            this.sharedFileListManager.getModel().getReadWriteLock().readLock().unlock();
        }
        return sharedWith;
    }

    private JLabel createHeaderLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(this.headerFont);
        label.setForeground(this.foreground);
        return label;
    }

    private boolean showConfirmation(String message) {
        if (!QuestionsHandler.CONFIRM_REMOVE_FILE_INFO_SHARING.getValue()) {
            return true;
        }
        YesNoCheckBoxDialog yesNoCheckBoxDialog = new YesNoCheckBoxDialog(I18n.tr("Remove File"), message, I18n.tr("Don't ask me again"), !QuestionsHandler.CONFIRM_REMOVE_FILE_INFO_SHARING.getValue(), I18n.tr("Yes"), I18n.tr("No"));
        yesNoCheckBoxDialog.setLocationRelativeTo(GuiUtils.getMainFrame());
        yesNoCheckBoxDialog.setVisible(true);
        QuestionsHandler.CONFIRM_REMOVE_FILE_INFO_SHARING.setValue(!yesNoCheckBoxDialog.isCheckBoxSelected());
        return yesNoCheckBoxDialog.isConfirmed();
    }

    private static class IconRenderer
    extends JPanel
    implements TableCellRenderer {
        private final JLabel label = new JLabel();

        public IconRenderer() {
            super(new BorderLayout());
            this.add((Component)this.label, "Center");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.label.setIcon((Icon)value);
            return this;
        }
    }

    private class RemoveEditor
    extends JPanel
    implements TableCellEditor {
        private final JButton button;
        private final List<CellEditorListener> listeners;
        private SharedFileList activeList;

        public RemoveEditor() {
            super(new BorderLayout());
            this.button = new RemoveButton();
            this.listeners = new ArrayList<CellEditorListener>();
            this.activeList = null;
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (FileInfoSharingPanel.this.showConfirmation(I18n.tr("Remove {0} from list {1}?", FileInfoSharingPanel.this.propertiableFile.getFileName(), RemoveEditor.this.activeList.getCollectionName()))) {
                        RemoveEditor.this.activeList.removeFile(((LocalFileItem)FileInfoSharingPanel.this.propertiableFile).getFile());
                    }
                }
            });
            this.add((Component)this.button, "Center");
        }

        @Override
        public Component getTableCellEditorComponent(JTable arg0, Object arg1, boolean arg2, int arg3, int arg4) {
            if (arg1 == null) {
                return null;
            }
            this.activeList = (SharedFileList)arg1;
            return this;
        }

        @Override
        public Object getCellEditorValue() {
            return this.activeList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addCellEditorListener(CellEditorListener lis) {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                if (!this.listeners.contains(lis)) {
                    this.listeners.add(lis);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelCellEditing() {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                int N = this.listeners.size();
                for (int i = 0; i < N; ++i) {
                    this.listeners.get(i).editingCanceled(new ChangeEvent(this));
                }
            }
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeCellEditorListener(CellEditorListener lis) {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                if (this.listeners.contains(lis)) {
                    this.listeners.remove(lis);
                }
            }
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean stopCellEditing() {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                int N = this.listeners.size();
                for (int i = 0; i < N; ++i) {
                    this.listeners.get(i).editingStopped(new ChangeEvent(this));
                }
            }
            return true;
        }
    }

    private class RemoveRenderer
    extends JPanel
    implements TableCellRenderer {
        private final JButton button;

        public RemoveRenderer() {
            super(new BorderLayout());
            this.button = new RemoveButton();
            this.add((Component)this.button, "Center");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this;
        }
    }
}

