/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.model;

import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.ui.swing.search.model.SimilarResultsDetector;
import org.limewire.ui.swing.search.model.VisualSearchResult;

public abstract class AbstractSimilarResultsDetector
implements SimilarResultsDetector {
    private static final Log LOG = LogFactory.getLog(AbstractSimilarResultsDetector.class);

    protected VisualSearchResult update(VisualSearchResult o1, VisualSearchResult o2) {
        VisualSearchResult parent = this.findParent(o1, o2);
        boolean childrenVisible = o1.isChildrenVisible() || o2.isChildrenVisible() || parent.isChildrenVisible() || o1.getSimilarityParent() != null && o1.getSimilarityParent().isChildrenVisible() || o2.getSimilarityParent() != null && o2.getSimilarityParent().isChildrenVisible() || parent.getSimilarityParent() != null && parent.getSimilarityParent().isChildrenVisible();
        this.updateParent(o1.getSimilarityParent(), parent);
        this.updateParent(o1, parent);
        this.updateParent(o2.getSimilarityParent(), parent);
        this.updateParent(o2, parent);
        this.updateVisibility(parent, childrenVisible);
        return parent;
    }

    private void updateVisibility(VisualSearchResult parent, boolean childrenVisible) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Setting child visibility for {0} to {1}", (Object)parent.getCoreSearchResults().get(0).getUrn(), (Object)childrenVisible);
        }
        parent.setVisible(true);
        parent.setChildrenVisible(childrenVisible);
    }

    private void updateParent(VisualSearchResult child, VisualSearchResult parent) {
        parent.setSimilarityParent(null);
        if (child != null && child != parent) {
            child.setSimilarityParent(parent);
            parent.addSimilarSearchResult(child);
            this.moveChildren(child, parent);
        }
    }

    private void moveChildren(VisualSearchResult child, VisualSearchResult parent) {
        child.removeSimilarSearchResult(parent);
        for (VisualSearchResult item : child.getSimilarResults()) {
            this.updateParent(item, parent);
            child.removeSimilarSearchResult(item);
            if (parent == item) continue;
            parent.addSimilarSearchResult(item);
        }
    }

    private VisualSearchResult findParent(VisualSearchResult o1, VisualSearchResult o2) {
        int parent2Count;
        VisualSearchResult parent1 = o1.getSimilarityParent();
        VisualSearchResult parent2 = o2.getSimilarityParent();
        int o1Count = o1.getSources().size();
        int o2Count = o2.getSources().size();
        int parent1Count = parent1 == null ? 0 : parent1.getSources().size();
        int n = parent2Count = parent2 == null ? 0 : parent2.getSources().size();
        assert (parent1 == null || parent1.getSimilarityParent() == null);
        assert (parent2 == null || parent2.getSimilarityParent() == null);
        if (parent2Count > parent1Count && parent2Count > o2Count && parent2Count > o1Count) {
            return parent2;
        }
        if (parent1Count > o2Count && parent1Count > o1Count) {
            return parent1;
        }
        if (o2Count > o1Count) {
            return o2;
        }
        if (o1Count > o2Count) {
            return o1;
        }
        if (parent1 != null) {
            return parent1;
        }
        if (parent2 != null) {
            return parent2;
        }
        return o1;
    }
}

