/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.model;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.limewire.core.api.search.SearchResult;
import org.limewire.ui.swing.search.model.AbstractNameSimilarResultsDetector;
import org.limewire.ui.swing.search.model.VisualSearchResult;

public class SimilarResultsFileNameDetector
extends AbstractNameSimilarResultsDetector {
    private static final String REPLACE = "\\(\\d\\)|[-_.' ()]";

    public SimilarResultsFileNameDetector() {
        super(Pattern.compile(REPLACE));
    }

    @Override
    public Set<String> getCleanIdentifyingStrings(VisualSearchResult visualSearchResult) {
        List<SearchResult> coreResults = visualSearchResult.getCoreSearchResults();
        HashSet<String> cleanFileNames = new HashSet<String>();
        for (SearchResult searchResult : coreResults) {
            String cleanFileName = this.nameCache.cleanString(searchResult.getFileName());
            cleanFileNames.add(cleanFileName);
        }
        return cleanFileNames;
    }
}

