/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.model;

import java.util.Comparator;
import org.limewire.ui.swing.search.model.BasicDownloadState;
import org.limewire.ui.swing.search.model.VisualSearchResult;

public abstract class SimilarResultsGroupingComparator
implements Comparator<VisualSearchResult> {
    @Override
    public int compare(VisualSearchResult o1, VisualSearchResult o2) {
        VisualSearchResult parent1 = o1.getSimilarityParent();
        VisualSearchResult parent2 = o2.getSimilarityParent();
        if (parent1 == o2) {
            return 1;
        }
        if (parent2 == o1) {
            return -1;
        }
        parent1 = parent1 == null ? o1 : parent1;
        parent2 = parent2 == null ? o2 : parent2;
        boolean spam1 = o1.isSpam();
        boolean spam2 = o2.isSpam();
        int compare = Boolean.valueOf(spam1).compareTo(spam2);
        if (compare == 0) {
            boolean library1 = o1.getDownloadState() == BasicDownloadState.LIBRARY;
            boolean library2 = o2.getDownloadState() == BasicDownloadState.LIBRARY;
            compare = Boolean.valueOf(library1).compareTo(library2);
        }
        if (compare == 0) {
            boolean preDownload1 = o1.isPreExistingDownload();
            boolean preDownload2 = o2.isPreExistingDownload();
            compare = Boolean.valueOf(preDownload1).compareTo(preDownload2);
        }
        if (compare == 0) {
            compare = this.doCompare(parent1, parent2);
        }
        if (compare == 0 && parent1 != parent2) {
            compare = Integer.valueOf(System.identityHashCode(parent1)).compareTo(System.identityHashCode(parent2));
        }
        return compare;
    }

    protected abstract int doCompare(VisualSearchResult var1, VisualSearchResult var2);
}

