/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.resultpanel.classic;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jdesktop.swingx.decorator.SortKey;
import org.jdesktop.swingx.decorator.SortOrder;
import org.limewire.core.api.Category;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.search.resultpanel.ResultsTableFormat;
import org.limewire.ui.swing.settings.TablesHandler;
import org.limewire.ui.swing.table.ColumnStateInfo;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.IconManager;

public class AllTableFormat
extends ResultsTableFormat<VisualSearchResult> {
    static final int FROM_INDEX = 0;
    static final int NAME_INDEX = 1;
    static final int EXTENSION_INDEX = 2;
    static final int TYPE_INDEX = 3;
    public static final int SIZE_INDEX = 4;
    static final int IS_SPAM_INDEX = 5;
    private final Provider<IconManager> iconManager;

    @Inject
    public AllTableFormat(Provider<IconManager> iconManager) {
        super("CLASSIC_SEARCH_ALL_TABLE", 1, 0, 5, new ColumnStateInfo(0, "CLASSIC_SEARCH_ALL_FROM", I18n.tr("From"), 88, true, true), new ColumnStateInfo(1, "CLASSIC_SEARCH_ALL_NAME", I18n.tr("Name"), 467, true, true), new ColumnStateInfo(2, "CLASSIC_SEARCH_ALL_EXTENSION", I18n.tr("Extension"), 95, true, true), new ColumnStateInfo(3, "CLASSIC_SEARCH_ALL_TYPE", I18n.tr("Type"), 110, true, true), new ColumnStateInfo(4, "CLASSIC_SEARCH_ALL_SIZE", I18n.tr("Size"), 83, true, true), new ColumnStateInfo(5, "CLASSIC_SEARCH_ALL_IS_SPAM", "", 10, false, false));
        this.iconManager = iconManager;
    }

    @Override
    public Class getColumnClass(int column) {
        switch (column) {
            case 1: {
                return Component.class;
            }
            case 4: {
                return Long.class;
            }
            case 0: {
                return VisualSearchResult.class;
            }
        }
        return super.getColumnClass(column);
    }

    @Override
    public Object getColumnValue(VisualSearchResult vsr, int column) {
        switch (column) {
            case 0: {
                return vsr;
            }
            case 1: {
                return vsr;
            }
            case 3: {
                if (vsr.getCategory() == Category.DOCUMENT || vsr.getCategory() == Category.PROGRAM || vsr.getCategory() == Category.OTHER) {
                    String mime = this.iconManager.get().getMIMEDescription(vsr.getFileExtension());
                    if (mime != null) {
                        return I18n.tr(vsr.getCategory().getSingularName()) + " (" + mime + ")";
                    }
                    return I18n.tr(vsr.getCategory().getSingularName());
                }
                return I18n.tr(vsr.getCategory().getSingularName());
            }
            case 4: {
                return vsr.getSize();
            }
            case 2: {
                return vsr.getFileExtension();
            }
            case 5: {
                return vsr;
            }
        }
        throw new IllegalArgumentException("Unknown column:" + column);
    }

    @Override
    public List<SortKey> getDefaultSortKeys() {
        if (TablesHandler.getSortedColumn(this.getSortOrderID(), this.getSortedColumn()).getValue() == this.getSortedColumn() && TablesHandler.getSortedOrder(this.getSortOrderID(), this.getSortOrder()).getValue() == this.getSortOrder()) {
            return Arrays.asList(new SortKey(SortOrder.DESCENDING, 0), new SortKey(SortOrder.ASCENDING, 1), new SortKey(SortOrder.ASCENDING, 3), new SortKey(SortOrder.ASCENDING, 4));
        }
        return super.getDefaultSortKeys();
    }

    @Override
    public List<Integer> getSecondarySortColumns(int column) {
        switch (column) {
            case 1: {
                return Arrays.asList(3, 4);
            }
            case 3: {
                return Arrays.asList(1, 4);
            }
            case 4: {
                return Arrays.asList(1, 3);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Comparator getNameComparator() {
        return new ResultsTableFormat.NameComparator(true);
    }
}

