/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.transfer;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.limewire.ui.swing.table.MouseableTable;
import org.limewire.ui.swing.table.TableColors;
import org.limewire.ui.swing.transfer.TransferRendererResources;

public abstract class TransferTable<E>
extends MouseableTable {
    private final DefaultEventTableModel<E> model;
    private final TransferRendererResources resources;

    public TransferTable(EventList<E> eventList, TableFormat<E> tableFormat) {
        this(new DefaultEventTableModel<E>(eventList, tableFormat));
    }

    public TransferTable(DefaultEventTableModel<E> model) {
        this.model = model;
        this.resources = new TransferRendererResources();
        this.setModel(model);
        this.setShowGrid(true, false);
        this.setEmptyRowsPainted(true);
        TableColors colors = this.getTableColors();
        this.setHighlighters(new ColorHighlighter(HighlightPredicate.EVEN, colors.evenColor, this.resources.getForeground(), colors.selectionColor, colors.selectionForeground), new ColorHighlighter(HighlightPredicate.ODD, colors.evenColor, this.resources.getForeground(), colors.selectionColor, colors.selectionForeground));
    }

    public Highlighter createDisabledHighlighter(HighlightPredicate predicate) {
        TableColors colors = this.getTableColors();
        return new ColorHighlighter(predicate, colors.evenColor, this.resources.getDisabledForeground(), colors.selectionColor, colors.selectionForeground);
    }

    public void setColumnEditor(int column, TableCellEditor editor) {
        this.getColumnModel().getColumn(column).setCellEditor(editor);
    }

    public void setColumnRenderer(int column, TableCellRenderer renderer) {
        this.getColumnModel().getColumn(column).setCellRenderer(renderer);
    }

    public void setColumnWidths(int index, int minWidth, int prefWidth, int maxWidth) {
        TableColumn column = this.getColumnModel().getColumn(index);
        column.setMinWidth(minWidth);
        column.setPreferredWidth(prefWidth);
        column.setMaxWidth(maxWidth);
    }

    public E getElementAt(int index) {
        return this.model.getElementAt(index);
    }

    public static class GapRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return super.getTableCellRendererComponent(table, null, isSelected, false, row, column);
        }
    }
}

