/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.update;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.core.api.Application;
import org.limewire.core.api.updates.UpdateInformation;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.components.ImageViewPort;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.NativeLaunchUtils;

public class UpdatePanel
extends JPanel {
    @Resource
    private Icon backgroundIcon;
    @Resource
    private Color backgroundColor;
    @Resource
    private Color foregroundColor;
    private final Application application;
    private final UpdateInformation updateInformation;
    private JButton leftButton;
    private JButton rightButton;

    public UpdatePanel(UpdateInformation updateInformation, Application application) {
        GuiUtils.assignResources(this);
        this.updateInformation = updateInformation;
        this.application = application;
        this.setBackground(this.backgroundColor);
        this.setLayout(new MigLayout("fill, insets 10 10 10 10, gap 6"));
        this.add((Component)this.createTopLabel(updateInformation.getUpdateTitle()), "alignx 50%, gapbottom 7, wrap");
        this.add((Component)this.createContentArea(updateInformation.getUpdateText()), "grow, wrap, gapbottom 10");
        this.add((Component)this.createLeftButton(new FirstButtonAction()), "alignx 50%, split, gapright 10");
        this.add((Component)this.createRightButton(new SecondButtonAction()), "alignx 50%");
    }

    public JButton getDefaultButton() {
        return this.leftButton;
    }

    private JComponent createTopLabel(String text) {
        JEditorPane pane = new JEditorPane();
        pane.setContentType("text/html");
        pane.setEditable(false);
        pane.addHyperlinkListener(GuiUtils.getHyperlinkListener());
        pane.setOpaque(false);
        text = this.updateForeground(this.foregroundColor, text);
        pane.setText(text);
        pane.setCaretPosition(0);
        return pane;
    }

    private JComponent createContentArea(String text) {
        JEditorPane pane = new JEditorPane();
        pane.setContentType("text/html");
        pane.setEditable(false);
        pane.addHyperlinkListener(GuiUtils.getHyperlinkListener());
        text = this.updateForeground(this.foregroundColor, text);
        pane.setText(text);
        pane.setCaretPosition(0);
        pane.setOpaque(false);
        pane.setMargin(new Insets(10, 115, 0, 0));
        ImageViewPort imageViewPort = new ImageViewPort(((ImageIcon)this.backgroundIcon).getImage());
        imageViewPort.setView(pane);
        JScrollPane scroller = new JScrollPane();
        scroller.setViewport(imageViewPort);
        scroller.setPreferredSize(new Dimension(355, 156));
        scroller.setHorizontalScrollBarPolicy(31);
        scroller.setVerticalScrollBarPolicy(20);
        scroller.setBorder(BorderFactory.createEmptyBorder());
        return scroller;
    }

    private JComponent createLeftButton(Action action) {
        this.leftButton = new JButton(action);
        this.leftButton.requestFocusInWindow();
        return this.leftButton;
    }

    private JComponent createRightButton(Action action) {
        this.rightButton = new JButton(action);
        return this.rightButton;
    }

    private String updateForeground(Color color, String html) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        String hex = GuiUtils.toHex(r) + GuiUtils.toHex(g) + GuiUtils.toHex(b);
        return "<html><body text='#" + hex + "'>" + html + "</body></html>";
    }

    private void close() {
        Window window = SwingUtilities.getWindowAncestor(this);
        window.setVisible(false);
        window.dispose();
    }

    private class SecondButtonAction
    extends AbstractAction {
        public SecondButtonAction() {
            String text = UpdatePanel.this.updateInformation.getButton2Text() != null && UpdatePanel.this.updateInformation.getButton2Text().length() > 0 ? UpdatePanel.this.updateInformation.getButton2Text() : I18n.tr("Update Later");
            this.putValue("Name", text);
            this.putValue("ShortDescription", I18n.tr("Visit http://www.limewire.com to update!"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UpdatePanel.this.close();
        }
    }

    private class FirstButtonAction
    extends AbstractAction {
        public FirstButtonAction() {
            String text = UpdatePanel.this.updateInformation.getButton1Text() != null && UpdatePanel.this.updateInformation.getButton1Text().length() > 0 ? UpdatePanel.this.updateInformation.getButton1Text() : I18n.tr("Update Now");
            this.putValue("Name", text);
            this.putValue("ShortDescription", I18n.tr("Visit http://www.limewire.com to update!"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String updateCommand = UpdatePanel.this.updateInformation.getUpdateCommand();
            if (updateCommand != null) {
                UpdatePanel.this.application.setShutdownFlag(updateCommand);
                int restartNow = FocusJOptionPane.showYesNoMessage(I18n.tr("LimeWire needs to be restarted to install the update. If you choose not to update now, LimeWire will update automatically when you close. Would you like to update now?"), I18n.tr("Update Ready"), 0, UpdatePanel.this);
                if (restartNow == 0) {
                    org.jdesktop.application.Application.getInstance().exit(e);
                }
            } else {
                NativeLaunchUtils.openURL(UpdatePanel.this.updateInformation.getUpdateURL());
            }
            UpdatePanel.this.close();
        }
    }
}

