/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.upload.table;

import org.limewire.core.api.upload.UploadItem;
import org.limewire.core.api.upload.UploadState;
import org.limewire.ui.swing.components.decorators.ProgressBarDecorator;
import org.limewire.ui.swing.transfer.TransferProgressRenderer;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.CommonUtils;

class UploadProgressRenderer
extends TransferProgressRenderer {
    public UploadProgressRenderer(ProgressBarDecorator progressBarDecorator) {
        super(progressBarDecorator);
    }

    @Override
    protected void updateProgress(Object value, int columnWidth) {
        if (value instanceof UploadItem) {
            UploadItem item = (UploadItem)value;
            if (UploadItem.UploadItemType.GNUTELLA == item.getUploadItemType()) {
                this.progressBar.setVisible(item.getState() == UploadState.UPLOADING && columnWidth > this.resources.getProgressBarCutoffWidth());
                if (this.progressBar.isVisible()) {
                    long size = item.getFileSize();
                    this.progressBar.setValue(size > 0L ? (int)(100L * item.getTotalAmountUploaded() / size) : 0);
                }
            } else {
                this.progressBar.setVisible(false);
            }
        } else {
            this.progressBar.setVisible(false);
        }
        this.progressBar.setEnabled(true);
    }

    @Override
    protected void updateTime(Object value) {
        if (value instanceof UploadItem) {
            UploadItem item = (UploadItem)value;
            if (UploadItem.UploadItemType.GNUTELLA == item.getUploadItemType()) {
                if (item.getState() == UploadState.UPLOADING && item.getRemainingUploadTime() <= 9223372036854774807L) {
                    this.timeLabel.setText(I18n.tr("{0} left", CommonUtils.seconds2time(item.getRemainingUploadTime())));
                    this.timeLabel.setMinimumSize(this.timeLabel.getPreferredSize());
                    this.timeLabel.setVisible(true);
                } else {
                    this.timeLabel.setVisible(false);
                }
            } else {
                this.timeLabel.setVisible(false);
            }
        } else {
            this.timeLabel.setVisible(false);
        }
    }
}

