/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.TransferHandler;
import org.limewire.util.OSUtils;
import org.limewire.util.URIUtils;

public class DNDUtils {
    public static final DataFlavor URIFlavor = DNDUtils.createURIFlavor();
    private static final List<DataFlavor> fileDataFlavors = new ArrayList<DataFlavor>();

    public static URI[] getURIs(Transferable transferable) throws UnsupportedFlavorException, IOException {
        String lines = (String)transferable.getTransferData(URIFlavor);
        StringTokenizer st = new StringTokenizer(lines, System.getProperty("line.separator"));
        ArrayList<URI> uris = new ArrayList<URI>();
        while (st.hasMoreTokens()) {
            String line = st.nextToken().trim();
            if (line.length() == 0) continue;
            try {
                URI uri = URIUtils.toURI(line);
                uris.add(uri);
            }
            catch (URISyntaxException e) {}
        }
        return uris.toArray(new URI[uris.size()]);
    }

    public static boolean containsFileFlavors(TransferHandler.TransferSupport transferSupport) {
        for (DataFlavor dataFlavor : DNDUtils.getFileFlavors()) {
            if (!transferSupport.isDataFlavorSupported(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public static DataFlavor[] getFileFlavors() {
        return fileDataFlavors.toArray(new DataFlavor[0]);
    }

    public static File[] getFiles(Transferable transferable) throws UnsupportedFlavorException, IOException {
        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return ((List)transferable.getTransferData(DataFlavor.javaFileListFlavor)).toArray(new File[0]);
        }
        if (transferable.isDataFlavorSupported(URIFlavor)) {
            return DNDUtils.getFiles(DNDUtils.getURIs(transferable));
        }
        return new File[0];
    }

    public static File[] getFiles(URI[] uris) {
        ArrayList<File> files = new ArrayList<File>(uris.length);
        for (URI uri : uris) {
            String scheme = uri.getScheme();
            if (!uri.isAbsolute() || scheme == null || !scheme.equalsIgnoreCase("file")) continue;
            String path = uri.getPath();
            files.add(new File(path));
        }
        return files.toArray(new File[files.size()]);
    }

    private static DataFlavor createURIFlavor() {
        try {
            return new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    public static boolean isFileFlavor(DataFlavor flavor) {
        return fileDataFlavors.contains(flavor);
    }

    static {
        if (OSUtils.isLinux()) {
            fileDataFlavors.add(URIFlavor);
        }
        fileDataFlavors.add(DataFlavor.javaFileListFlavor);
    }
}

