/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import foxtrot.Job;
import foxtrot.Worker;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.service.ErrorService;
import org.limewire.ui.swing.components.LimeJFrame;
import org.limewire.ui.swing.util.MacUtils;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

public class MacOSXUtils {
    public static final String LIMEWIRE_APPLICATION_BUNDLE_IDENTIFIER = "com.limegroup.gnutella";
    private static final String APP_NAME = "LimeWire.app";
    private static boolean nativeLibraryLoadedCorrectly = false;
    private static final Log LOG = LogFactory.getLog(MacOSXUtils.class);

    public static boolean isNativeLibraryLoadedCorrectly() {
        return nativeLibraryLoadedCorrectly;
    }

    private MacOSXUtils() {
    }

    public static String traceLibraryDependencies(String libraryName) {
        StringBuffer traceResultsBuffer = new StringBuffer("ls command output: ");
        String lsCommand = "ls " + System.getProperty("user.dir");
        traceResultsBuffer.append("(").append(lsCommand).append(") ");
        traceResultsBuffer.append(MacOSXUtils.getCommandOutput(lsCommand));
        traceResultsBuffer.append("\n");
        String otoolCommand = "otool -L " + System.getProperty("user.dir") + "/" + libraryName;
        traceResultsBuffer.append("otool command output: ");
        traceResultsBuffer.append(MacOSXUtils.getCommandOutput(otoolCommand));
        traceResultsBuffer.append("\n");
        return traceResultsBuffer.toString();
    }

    private static String getCommandOutput(String command) {
        StringBuffer outputBuffer = new StringBuffer("");
        try {
            String line;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(command);
            InputStream inputstream = process.getInputStream();
            InputStreamReader inputstreamreader = new InputStreamReader(inputstream);
            BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
            while ((line = bufferedreader.readLine()) != null) {
                outputBuffer.append(line).append("\n");
            }
            try {
                if (process.waitFor() != 0) {
                    outputBuffer.append("exit value = ");
                    outputBuffer.append(process.exitValue());
                }
            }
            catch (InterruptedException e) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputBuffer.toString();
    }

    public static void setLoginStatus(boolean allow) {
        try {
            MacOSXUtils.SetLoginStatusNative(allow);
        }
        catch (UnsatisfiedLinkError ule) {
            LOG.error("UnsatisfiedLinkError for MacOSXUtils", ule);
        }
    }

    public static String getUserName() {
        try {
            return MacOSXUtils.GetCurrentFullUserName();
        }
        catch (UnsatisfiedLinkError ule) {
            LOG.error("UnsatisfiedLinkError for MacOSXUtils", ule);
            return CommonUtils.getUserName();
        }
    }

    public static String getAppDir() {
        String appDir = "/Applications/LimeWire/";
        String path = CommonUtils.getCurrentDirectory().getPath();
        int app = path.indexOf(APP_NAME);
        if (app != -1) {
            appDir = path.substring(0, app);
        }
        return appDir + APP_NAME;
    }

    public static void setLimewireAsDefaultFileTypeHandler(String fileType) {
        try {
            MacOSXUtils.SetDefaultFileTypeHandler(fileType, LIMEWIRE_APPLICATION_BUNDLE_IDENTIFIER);
        }
        catch (UnsatisfiedLinkError ule) {
            LOG.error("UnsatisfiedLinkError for MacOSXUtils", ule);
        }
    }

    public static void setLimewireAsDefaultURLSchemeHandler(String urlScheme) {
        try {
            MacOSXUtils.SetDefaultURLSchemeHandler(urlScheme, LIMEWIRE_APPLICATION_BUNDLE_IDENTIFIER);
        }
        catch (UnsatisfiedLinkError ule) {
            LOG.error("UnsatisfiedLinkError for MacOSXUtils", ule);
        }
    }

    public static boolean isLimewireDefaultFileTypeHandler(String fileType) {
        try {
            return MacOSXUtils.IsApplicationTheDefaultFileTypeHandler(fileType, LIMEWIRE_APPLICATION_BUNDLE_IDENTIFIER);
        }
        catch (UnsatisfiedLinkError ule) {
            LOG.error("UnsatisfiedLinkError for MacOSXUtils", ule);
            return true;
        }
    }

    public static boolean isLimewireDefaultURLSchemeHandler(String urlScheme) {
        try {
            return MacOSXUtils.IsApplicationTheDefaultURLSchemeHandler(urlScheme, LIMEWIRE_APPLICATION_BUNDLE_IDENTIFIER);
        }
        catch (UnsatisfiedLinkError ule) {
            LOG.error("UnsatisfiedLinkError for MacOSXUtils", ule);
            return true;
        }
    }

    public static boolean isFileTypeHandled(String fileType) {
        try {
            return MacOSXUtils.IsFileTypeHandled(fileType);
        }
        catch (UnsatisfiedLinkError ule) {
            LOG.error("UnsatisfiedLinkError for MacOSXUtils", ule);
            return true;
        }
    }

    public static boolean isURLSchemeHandled(String urlScheme) {
        try {
            return MacOSXUtils.IsURLSchemeHandled(urlScheme);
        }
        catch (UnsatisfiedLinkError ule) {
            LOG.error("UnsatisfiedLinkError for MacOSXUtils", ule);
            return true;
        }
    }

    public static void tryChangingDefaultFileTypeHandler(String fileType) {
        block3: {
            try {
                String[] handlers = MacOSXUtils.GetAllHandlersForFileType(fileType);
                if (handlers == null) break block3;
                for (String handler : handlers) {
                    if (handler.equals(LIMEWIRE_APPLICATION_BUNDLE_IDENTIFIER)) continue;
                    MacOSXUtils.SetDefaultFileTypeHandler(fileType, handler);
                    break;
                }
            }
            catch (UnsatisfiedLinkError ule) {
                LOG.error("UnsatisfiedLinkError for MacOSXUtils", ule);
            }
        }
    }

    public static boolean canChangeDefaultFileTypeHandler(String fileType) {
        try {
            String[] handlers = MacOSXUtils.GetAllHandlersForFileType(fileType);
            if (handlers != null) {
                for (String handler : handlers) {
                    if (handler.equals(LIMEWIRE_APPLICATION_BUNDLE_IDENTIFIER)) continue;
                    return true;
                }
            }
        }
        catch (UnsatisfiedLinkError ule) {
            LOG.error("UnsatisfiedLinkError for MacOSXUtils", ule);
        }
        return false;
    }

    public static void tryChangingDefaultURLSchemeHandler(String urlScheme) {
        block3: {
            try {
                String[] handlers = MacOSXUtils.GetAllHandlersForURLScheme(urlScheme);
                if (handlers == null) break block3;
                for (String handler : handlers) {
                    if (handler.equals(LIMEWIRE_APPLICATION_BUNDLE_IDENTIFIER)) continue;
                    MacOSXUtils.SetDefaultURLSchemeHandler(urlScheme, handler);
                    break;
                }
            }
            catch (UnsatisfiedLinkError ule) {
                LOG.error("UnsatisfiedLinkError for MacOSXUtils", ule);
            }
        }
    }

    public static boolean canChangeDefaultURLSchemeHandler(String urlScheme) {
        try {
            String[] handlers = MacOSXUtils.GetAllHandlersForURLScheme(urlScheme);
            if (handlers != null) {
                for (String handler : handlers) {
                    if (handler.equals(LIMEWIRE_APPLICATION_BUNDLE_IDENTIFIER)) continue;
                    return true;
                }
            }
        }
        catch (UnsatisfiedLinkError ule) {
            LOG.error("UnsatisfiedLinkError for MacOSXUtils", ule);
        }
        return false;
    }

    public static List<File> openNativeFileDialog(final String dialogTitle, File directory, final boolean canChooseFiles, final boolean canChooseDirectories, final boolean allowMultipleSelections, FileFilter filter) {
        try {
            final String directoryAbsolutePath = directory != null ? directory.getAbsolutePath() : null;
            String[] filePaths = (String[])Worker.post(new Job(){

                @Override
                public Object run() {
                    String[] filePaths = MacOSXUtils.OpenNativeFileDialog(dialogTitle, directoryAbsolutePath, canChooseFiles, canChooseDirectories, allowMultipleSelections);
                    return filePaths;
                }
            });
            if (filePaths == null) {
                return null;
            }
            ArrayList<File> selectedFileList = new ArrayList<File>();
            for (String filePath : filePaths) {
                File selectedFile = new File(filePath);
                if (filter != null) {
                    if (!filter.accept(selectedFile)) continue;
                    selectedFileList.add(selectedFile);
                    continue;
                }
                selectedFileList.add(selectedFile);
            }
            return selectedFileList;
        }
        catch (UnsatisfiedLinkError ule) {
            return MacOSXUtils.openJavaFileDialog(dialogTitle, directory, canChooseFiles, canChooseDirectories, allowMultipleSelections, filter);
        }
    }

    private static List<File> openJavaFileDialog(String dialogTitle, File directory, boolean canChooseFiles, boolean canChooseDirectories, boolean allowMultipleSelections, final FileFilter filter) {
        FileDialog dialog = canChooseDirectories && !canChooseFiles ? MacUtils.getFolderDialog(null) : new FileDialog((Frame)new LimeJFrame(), "");
        dialog.setTitle(dialogTitle);
        if (filter != null) {
            FilenameFilter f = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return filter.accept(new File(dir, name));
                }
            };
            dialog.setFilenameFilter(f);
        }
        dialog.setVisible(true);
        String dirStr = dialog.getDirectory();
        String fileStr = dialog.getFile();
        if (dirStr == null || fileStr == null) {
            return null;
        }
        File f = new File(dirStr, fileStr);
        if (filter != null && !filter.accept(f)) {
            return null;
        }
        return Collections.singletonList(f);
    }

    private static final native boolean IsFileTypeHandled(String var0);

    private static final native boolean IsURLSchemeHandled(String var0);

    private static final native boolean IsApplicationTheDefaultFileTypeHandler(String var0, String var1);

    private static final native boolean IsApplicationTheDefaultURLSchemeHandler(String var0, String var1);

    private static final native int SetDefaultFileTypeHandler(String var0, String var1);

    private static final native int SetDefaultURLSchemeHandler(String var0, String var1);

    private static final native String[] GetAllHandlersForFileType(String var0);

    private static final native String[] GetAllHandlersForURLScheme(String var0);

    private static final native String[] OpenNativeFileDialog(String var0, String var1, boolean var2, boolean var3, boolean var4);

    private static final native String GetCurrentFullUserName();

    private static final native void SetLoginStatusNative(boolean var0);

    static {
        if (OSUtils.isMacOSX()) {
            try {
                System.loadLibrary("MacOSXUtils");
                nativeLibraryLoadedCorrectly = true;
            }
            catch (UnsatisfiedLinkError err) {
                ErrorService.error(err, "java.library.path=" + System.getProperty("java.library.path") + "\n\n" + "trace dependencies=" + MacOSXUtils.traceLibraryDependencies("MacOSXUtils.jnilib"));
            }
        }
    }
}

