/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;

public class PainterUtils {
    public static final Color TRASPARENT = new Color(0, 0, 0, 0);
    public static final Insets BLANK_INSETS = new Insets(0, 0, 0, 0);

    public static void drawSmoothString(Graphics g, String s, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        Object origAntiAliasHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawString(s, x, y);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, origAntiAliasHint);
    }

    public static Color lighten(Color orig, int intensity) {
        return PainterUtils.lighten(orig, Color.WHITE, intensity);
    }

    public static Color lighten(Color orig, Color threshold, int intensity) {
        if (TRASPARENT.equals(orig)) {
            if (intensity >= 0) {
                return TRASPARENT;
            }
            return PainterUtils.lighten(threshold, threshold, intensity);
        }
        int red = orig.getRed() + intensity;
        int green = orig.getGreen() + intensity;
        int blue = orig.getBlue() + intensity;
        if (intensity > 0) {
            red = Math.min(red, 255);
            green = Math.min(green, 255);
            blue = Math.min(blue, 255);
        } else {
            red = Math.max(red, 0);
            green = Math.max(green, 0);
            blue = Math.max(blue, 0);
        }
        if (intensity > 0 && red >= threshold.getRed() && green >= threshold.getGreen() && blue >= threshold.getBlue()) {
            return TRASPARENT;
        }
        return new Color(red, green, blue);
    }

    public static ConvolveOp createSoftenFilter(float factor) {
        float[] transform = new float[]{0.0f, factor, 0.0f, factor, 1.0f - factor * 4.0f, factor, 0.0f, factor, 0.0f};
        Kernel kernel = new Kernel(3, 3, transform);
        return new ConvolveOp(kernel, 1, null);
    }

    public static Color appendAlpha(Color c, double opacity) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)Math.round(opacity * 255.0));
    }

    public static Color getColour(Paint paint) {
        if (paint instanceof Color) {
            return (Color)paint;
        }
        if (paint instanceof GradientPaint) {
            return ((GradientPaint)paint).getColor2();
        }
        return null;
    }
}

