/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;

public class SearchSettingListener
implements SettingListener {
    private final JComboBox combo;
    private final BooleanSetting booleanSetting;
    private final SearchCategory searchCategory;
    private boolean oldValue;

    public SearchSettingListener(BooleanSetting booleanSetting, SearchCategory searchCategory, JComboBox combo) {
        this.booleanSetting = booleanSetting;
        this.searchCategory = searchCategory;
        this.combo = combo;
        this.oldValue = booleanSetting.getValue();
        if (!booleanSetting.getValue()) {
            combo.removeItem((Object)searchCategory);
        }
    }

    @Override
    public void settingChanged(SettingEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean newValue = SearchSettingListener.this.booleanSetting.getValue();
                if (SearchSettingListener.this.oldValue != newValue) {
                    if (newValue) {
                        SearchSettingListener.this.combo.addItem(SearchSettingListener.this.searchCategory);
                    } else {
                        if (SearchSettingListener.this.combo.getSelectedItem() == SearchSettingListener.this.searchCategory) {
                            SearchSettingListener.this.combo.setSelectedItem((Object)SearchCategory.ALL);
                        }
                        SearchSettingListener.this.combo.removeItem((Object)SearchSettingListener.this.searchCategory);
                    }
                    SearchSettingListener.this.oldValue = newValue;
                }
            }
        });
    }
}

