/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.wizard;

import java.awt.Component;
import javax.swing.JCheckBox;
import net.miginfocom.swing.MigLayout;
import org.limewire.core.api.Application;
import org.limewire.core.settings.ApplicationSettings;
import org.limewire.core.settings.ContentSettings;
import org.limewire.core.settings.InstallSettings;
import org.limewire.ui.swing.settings.StartupSettings;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.shell.LimeAssociationOption;
import org.limewire.ui.swing.shell.LimeAssociations;
import org.limewire.ui.swing.util.BackgroundExecutorService;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.MacOSXUtils;
import org.limewire.ui.swing.util.WindowsUtils;
import org.limewire.ui.swing.wizard.SetupComponentDecorator;
import org.limewire.ui.swing.wizard.WizardPage;
import org.limewire.util.OSUtils;

public class SetupPage1
extends WizardPage {
    private final JCheckBox associationFileTypeCheckBox;
    private final JCheckBox launchAtStartupCheckBox;
    private final JCheckBox shareUsageDataCheckBox;
    private final JCheckBox contentFilterCheckBox;

    public SetupPage1(SetupComponentDecorator decorator, Application application) {
        super(decorator, application);
        this.setOpaque(false);
        this.setLayout(new MigLayout("insets 0 14 0 0, gap 0, nogrid"));
        this.associationFileTypeCheckBox = this.createAndDecorateCheckBox(true);
        this.launchAtStartupCheckBox = this.createAndDecorateCheckBox(true);
        this.shareUsageDataCheckBox = this.createAndDecorateCheckBox(true);
        this.contentFilterCheckBox = this.createAndDecorateCheckBox(false);
        this.addFileAssociations();
        this.addImproving();
        this.addContentFilters();
        this.initSettings();
    }

    private void addFileAssociations() {
        if (LimeAssociations.isMagnetAssociationSupported() || LimeAssociations.isTorrentAssociationSupported() || this.shouldShowStartOnStartupWindow()) {
            this.add((Component)this.createAndDecorateHeader(I18n.tr("File Associations and Startup")), "gaptop 20, span, wrap");
            if (LimeAssociations.isMagnetAssociationSupported() || LimeAssociations.isTorrentAssociationSupported()) {
                this.add((Component)this.associationFileTypeCheckBox, "gaptop 5, gapleft 26");
                this.add((Component)this.createAndDecorateMultiLine(I18n.tr("Associate .magnet and .torrent files with LimeWire"), this.associationFileTypeCheckBox), "gaptop 5, gapleft 5, wrap");
            }
            if (this.shouldShowStartOnStartupWindow()) {
                this.add((Component)this.launchAtStartupCheckBox, "gaptop 5, gapleft 26");
                this.add((Component)this.createAndDecorateMultiLine(I18n.tr("Launch LimeWire at system startup"), this.launchAtStartupCheckBox), "gaptop 5, gapleft 5, wrap");
            }
        }
    }

    private void addImproving() {
        this.add((Component)this.createAndDecorateHeader(I18n.tr("Improve LimeWire")), "gaptop 20, span, wrap");
        this.add((Component)this.shareUsageDataCheckBox, "gaptop 5, gapleft 26");
        this.add((Component)this.createAndDecorateMultiLine(I18n.tr("Help improve LimeWire by sending us anonymous usage data"), this.shareUsageDataCheckBox), "gapleft 5, gaptop 5");
        this.add((Component)this.createAndDecorateHyperlink("http://www.limewire.com/client_redirect/?page=anonymousDataCollection"), "gapleft 10, gaptop 5, wrap");
    }

    private void addContentFilters() {
        this.add((Component)this.createAndDecorateHeader(I18n.tr("Content Filters")), "gaptop 20, span, wrap");
        this.add((Component)this.contentFilterCheckBox, "gaptop 5, gapleft 26");
        this.add((Component)this.createAndDecorateMultiLine(I18n.tr("Don't let me download or upload files copyright owners request not be shared"), this.contentFilterCheckBox), "gapleft 5, gaptop 5");
        this.add((Component)this.createAndDecorateHyperlink("http://www.limewire.com/client_redirect/?page=contentFiltering"), "gapleft 10, gaptop 5, wrap");
    }

    private void initSettings() {
        this.associationFileTypeCheckBox.setSelected(SwingUiSettings.HANDLE_MAGNETS.getValue());
        this.launchAtStartupCheckBox.setSelected(StartupSettings.RUN_ON_STARTUP.getValue());
        this.shareUsageDataCheckBox.setSelected(ApplicationSettings.ALLOW_ANONYMOUS_STATISTICS_GATHERING.getValue());
        this.contentFilterCheckBox.setSelected(ContentSettings.USER_WANTS_MANAGEMENTS.getValue());
    }

    @Override
    public String getLine1() {
        return I18n.tr("Please take a minute to configure these options before moving on.");
    }

    @Override
    public String getLine2() {
        return "";
    }

    @Override
    public String getFooter() {
        return OSUtils.isMacOSX() ? I18n.tr("All settings can be changed later from LimeWire > Preferences") : I18n.tr("All settings can be changed later in Tools > Options");
    }

    @Override
    public void applySettings() {
        SwingUiSettings.HANDLE_MAGNETS.setValue(this.associationFileTypeCheckBox.isSelected());
        LimeAssociationOption magnetAssociationOption = LimeAssociations.getMagnetAssociation();
        if (magnetAssociationOption != null) {
            magnetAssociationOption.setEnabled(this.associationFileTypeCheckBox.isSelected());
        }
        SwingUiSettings.HANDLE_TORRENTS.setValue(this.associationFileTypeCheckBox.isSelected());
        LimeAssociationOption torrentAssociationOption = LimeAssociations.getTorrentAssociation();
        if (torrentAssociationOption != null) {
            torrentAssociationOption.setEnabled(this.associationFileTypeCheckBox.isSelected());
        }
        InstallSettings.ASSOCIATION_OPTION.setValue(2);
        if (this.shouldShowStartOnStartupWindow()) {
            if (OSUtils.isMacOSX()) {
                MacOSXUtils.setLoginStatus(this.launchAtStartupCheckBox.isSelected());
            } else if (WindowsUtils.isLoginStatusAvailable()) {
                BackgroundExecutorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        WindowsUtils.setLoginStatus(SetupPage1.this.launchAtStartupCheckBox.isSelected());
                    }
                });
            }
            StartupSettings.RUN_ON_STARTUP.setValue(this.launchAtStartupCheckBox.isSelected());
        } else {
            StartupSettings.RUN_ON_STARTUP.setValue(false);
        }
        InstallSettings.START_STARTUP.setValue(true);
        ApplicationSettings.ALLOW_ANONYMOUS_STATISTICS_GATHERING.setValue(this.shareUsageDataCheckBox.isSelected());
        InstallSettings.ANONYMOUS_DATA_COLLECTION.setValue(true);
        ContentSettings.USER_WANTS_MANAGEMENTS.setValue(this.contentFilterCheckBox.isSelected());
        InstallSettings.FILTER_OPTION.setValue(true);
    }

    private boolean shouldShowStartOnStartupWindow() {
        return OSUtils.isMacOSX() || OSUtils.isGoodWindows();
    }
}

