/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.limewire.util.FileUtils;
import org.limewire.util.I18NConvert;
import org.limewire.util.OSUtils;

public class CommonUtils {
    private static final char[] ILLEGAL_CHARS_ANY_OS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f'};
    private static final char[] ILLEGAL_CHARS_UNIX = new char[]{'`'};
    private static final char[] ILLEGAL_CHARS_WINDOWS = new char[]{'?', '*', '\\', '<', '>', '|', '\"', ':'};
    private static final char[] ILLEGAL_CHARS_MACOS = new char[]{':'};
    private static volatile File settingsDirectory = null;

    public static File getUserHomeDir() {
        return new File(System.getProperty("user.home"));
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static InputStream getResourceStream(String location) throws IOException {
        ClassLoader cl = CommonUtils.class.getClassLoader();
        URL resource = null;
        resource = cl == null ? ClassLoader.getSystemResource(location) : cl.getResource(location);
        if (resource == null) {
            throw new IOException("null resource: " + location);
        }
        return resource.openStream();
    }

    public static String decode(String s) {
        StringBuilder sb = new StringBuilder();
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    continue block8;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(s);
                    }
                    i += 2;
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        String result = sb.toString();
        try {
            byte[] inputBytes = result.getBytes("8859_1");
            result = new String(inputBytes);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    public static void copyResourceFile(String fileName, File newFile, boolean forceOverwrite) throws IOException {
        ClassLoader cl;
        URL resource;
        if (newFile == null) {
            newFile = new File(".", fileName);
        }
        if (!forceOverwrite && newFile.exists()) {
            return;
        }
        String parentString = newFile.getParent();
        if (parentString == null) {
            return;
        }
        File parentFile = new File(parentString);
        if (!parentFile.isDirectory()) {
            parentFile.mkdirs();
        }
        URL uRL = resource = (cl = CommonUtils.class.getClassLoader()) != null ? cl.getResource(fileName) : ClassLoader.getSystemResource(fileName);
        if (resource == null) {
            throw new IOException("resource: " + fileName + " doesn't exist.");
        }
        CommonUtils.saveStream(resource.openStream(), newFile);
    }

    public static void copyFile(File src, File dst) throws IOException {
        CommonUtils.saveStream(new FileInputStream(src), dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveStream(InputStream inStream, File newFile) throws IOException {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int bufferSize = 2048;
            bis = new BufferedInputStream(inStream, 2048);
            bos = new BufferedOutputStream(new FileOutputStream(newFile), 2048);
            byte[] buffer = new byte[2048];
            int c = 0;
            do {
                if ((c = bis.read(buffer, 0, 2048)) <= 0) continue;
                ((BufferedOutputStream)bos).write(buffer, 0, c);
            } while (c == 2048);
            ((BufferedOutputStream)bos).flush();
        }
        catch (IOException e) {
            newFile.delete();
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ignored) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public static String seconds2time(long seconds) {
        long minutes = seconds / 60L;
        seconds -= minutes * 60L;
        long hours = minutes / 60L;
        minutes -= hours * 60L;
        long days = hours / 24L;
        hours -= days * 24L;
        StringBuilder time = new StringBuilder();
        if (days != 0L) {
            time.append(Long.toString(days));
            time.append(":");
            if (hours < 10L) {
                time.append("0");
            }
        }
        if (days != 0L || hours != 0L) {
            time.append(Long.toString(hours));
            time.append(":");
            if (minutes < 10L) {
                time.append("0");
            }
        }
        time.append(Long.toString(minutes));
        time.append(":");
        if (seconds < 10L) {
            time.append("0");
        }
        time.append(Long.toString(seconds));
        return time.toString();
    }

    public static String convertFileName(File parentDir, String name) throws IOException {
        int parentLength = FileUtils.getCanonicalFile(parentDir).getAbsolutePath().getBytes(Charset.defaultCharset().name()).length;
        if (parentLength >= OSUtils.getMaxPathLength() - 1) {
            throw new IOException("Path too long");
        }
        return CommonUtils.convertFileName(name, Math.min(OSUtils.getMaxPathLength() - parentLength - 1, 180));
    }

    public static String convertFileName(String name) {
        return CommonUtils.convertFileName(name, 180);
    }

    public static String convertFileName(String name, int maxBytes) {
        try {
            return CommonUtils.convertFileName(name, maxBytes, Charset.defaultCharset());
        }
        catch (CharacterCodingException cce) {
            try {
                return CommonUtils.convertFileName(name, maxBytes, Charset.forName("UTF-8"));
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException("UTF-8 should have encoded: " + name, e);
            }
        }
    }

    public static String convertFileName(String name, int maxBytes, Charset charSet) throws CharacterCodingException {
        block11: {
            block12: {
                block10: {
                    if (maxBytes <= 0) {
                        throw new IllegalArgumentException("maxBytes must be > 0");
                    }
                    name = I18NConvert.instance().compose(name);
                    if (name.length() > maxBytes || name.getBytes().length > maxBytes) {
                        int extStart = name.lastIndexOf(46);
                        if (extStart == -1) {
                            name = CommonUtils.getPrefixWithMaxBytes(name, maxBytes, charSet);
                        } else {
                            int extLength = name.length() - extStart;
                            int extEnd = extLength > 11 ? extStart + 11 : name.length();
                            byte[] extension = CommonUtils.getMaxBytes(name.substring(extStart, extEnd), 16, charSet);
                            try {
                                name = extension.length >= maxBytes - 10 ? CommonUtils.getPrefixWithMaxBytes(name, maxBytes, charSet) : CommonUtils.getPrefixWithMaxBytes(name, maxBytes - extension.length, charSet) + new String(extension, charSet.name());
                            }
                            catch (UnsupportedEncodingException uee) {
                                throw new RuntimeException("Could not handle string", uee);
                            }
                        }
                    }
                    for (char aILLEGAL_CHARS_ANY_OS : ILLEGAL_CHARS_ANY_OS) {
                        name = name.replace(aILLEGAL_CHARS_ANY_OS, '_');
                    }
                    if (!OSUtils.isWindows() && !OSUtils.isOS2()) break block10;
                    for (char aILLEGAL_CHARS_WINDOWS : ILLEGAL_CHARS_WINDOWS) {
                        name = name.replace(aILLEGAL_CHARS_WINDOWS, '_');
                    }
                    break block11;
                }
                if (!OSUtils.isLinux() && !OSUtils.isSolaris()) break block12;
                for (char aILLEGAL_CHARS_UNIX : ILLEGAL_CHARS_UNIX) {
                    name = name.replace(aILLEGAL_CHARS_UNIX, '_');
                }
                break block11;
            }
            if (!OSUtils.isMacOSX()) break block11;
            for (char aILLEGAL_CHARS_MACOS : ILLEGAL_CHARS_MACOS) {
                name = name.replace(aILLEGAL_CHARS_MACOS, '_');
            }
        }
        return name;
    }

    public static String sanitizeFolderName(String name) throws IOException {
        String result = CommonUtils.santizeString(name).trim();
        int index = result.length();
        while (result.charAt(index - 1) == '.') {
            if (--index > 0) continue;
            throw new IOException("folder does not contain valid characters");
        }
        if (index == result.length()) {
            return result;
        }
        return result.substring(0, index);
    }

    public static String santizeString(String name) {
        block5: {
            block6: {
                block4: {
                    for (char aILLEGAL_CHARS_ANY_OS : ILLEGAL_CHARS_ANY_OS) {
                        name = name.replace(aILLEGAL_CHARS_ANY_OS, '_');
                    }
                    if (!OSUtils.isWindows() && !OSUtils.isOS2()) break block4;
                    for (char aILLEGAL_CHARS_WINDOWS : ILLEGAL_CHARS_WINDOWS) {
                        name = name.replace(aILLEGAL_CHARS_WINDOWS, '_');
                    }
                    break block5;
                }
                if (!OSUtils.isLinux() && !OSUtils.isSolaris()) break block6;
                for (char aILLEGAL_CHARS_UNIX : ILLEGAL_CHARS_UNIX) {
                    name = name.replace(aILLEGAL_CHARS_UNIX, '_');
                }
                break block5;
            }
            if (!OSUtils.isMacOSX()) break block5;
            for (char aILLEGAL_CHARS_MACOS : ILLEGAL_CHARS_MACOS) {
                name = name.replace(aILLEGAL_CHARS_MACOS, '_');
            }
        }
        return name;
    }

    static String getPrefixWithMaxBytes(String string, int maxBytes, Charset charSet) throws CharacterCodingException {
        try {
            return new String(CommonUtils.getMaxBytes(string, maxBytes, charSet), charSet.name());
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Could not recreate string", uee);
        }
    }

    static byte[] getMaxBytes(String string, int maxBytes, Charset charSet) throws CharacterCodingException {
        byte[] bytes = new byte[maxBytes];
        ByteBuffer out = ByteBuffer.wrap(bytes);
        CharBuffer in = CharBuffer.wrap(string.toCharArray());
        CharsetEncoder encoder = charSet.newEncoder();
        CoderResult cr = encoder.encode(in, out, true);
        encoder.flush(out);
        if (cr.isError()) {
            cr.throwException();
        }
        byte[] result = new byte[out.position()];
        System.arraycopy(bytes, 0, result, 0, result.length);
        return result;
    }

    public static File getCurrentDirectory() {
        return new File(System.getProperty("user.dir"));
    }

    public static File validateSettingsDirectory(File dir) throws IOException {
        if (!(dir = dir.getAbsoluteFile()).isDirectory()) {
            dir.delete();
            if (!dir.mkdirs()) {
                throw new IOException("could not create preferences directory: " + dir);
            }
        }
        if (!FileUtils.canWrite(dir)) {
            throw new IOException("settings dir not writable: " + dir);
        }
        if (!dir.canRead()) {
            throw new IOException("settings dir not readable: " + dir);
        }
        File file = File.createTempFile("test", "test", dir);
        if (!file.exists()) {
            throw new IOException("can't write test file in directory: " + dir);
        }
        file.delete();
        return dir;
    }

    public static void setUserSettingsDir(File settingsDir) throws IOException {
        if (settingsDirectory != null) {
            throw new IllegalStateException("settings directory already set!");
        }
        settingsDirectory = CommonUtils.validateSettingsDirectory(settingsDir);
    }

    public static synchronized File getUserSettingsDir() {
        if (settingsDirectory != null) {
            return settingsDirectory;
        }
        return CommonUtils.getUserHomeDir();
    }

    public static Long parseLongNoException(String str) {
        Long num = null;
        if (str != null) {
            try {
                num = Long.valueOf(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return num;
    }
}

