/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

public class DebugRunnable
implements Runnable {
    private final Exception creationTime = new Exception("Debug Exception Creation");
    private final Runnable delegate;

    public DebugRunnable(Runnable runner) {
        this.delegate = runner;
        StackTraceElement[] trace = this.creationTime.getStackTrace();
        StackTraceElement[] newTrace = new StackTraceElement[trace.length - 1];
        System.arraycopy(trace, 1, newTrace, 0, newTrace.length);
        this.creationTime.setStackTrace(newTrace);
    }

    @Override
    public final void run() {
        boolean setStackTrace = true;
        try {
            this.delegate.run();
        }
        catch (Throwable t) {
            if (t.getCause() == null) {
                try {
                    t.initCause(this.creationTime);
                    setStackTrace = false;
                }
                catch (IllegalStateException ise) {
                    // empty catch block
                }
            }
            if (setStackTrace) {
                StackTraceElement[] trace = t.getStackTrace();
                StackTraceElement[] createdTrace = this.creationTime.getStackTrace();
                StackTraceElement[] combinedTrace = new StackTraceElement[trace.length + createdTrace.length];
                System.arraycopy(trace, 0, combinedTrace, 0, trace.length);
                System.arraycopy(createdTrace, 0, combinedTrace, trace.length, createdTrace.length);
                t.setStackTrace(combinedTrace);
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }
}

