/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.util.Comparator;

public class Objects {
    private Objects() {
    }

    public static <T> T nonNull(T t, String msg) {
        if (t == null) {
            throw new NullPointerException("null: " + msg);
        }
        return t;
    }

    public static boolean equalOrNull(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static <T extends Comparable> int compareToNull(T o1, T o2) {
        return Objects.compareToNull(o1, o2, true);
    }

    public static <T extends Comparable> int compareToNull(T o1, T o2, boolean nullsFirst) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return nullsFirst ? -1 : 1;
        }
        if (o2 == null) {
            return nullsFirst ? 1 : -1;
        }
        return o1.compareTo(o2);
    }

    public static int compareToNullIgnoreCase(String o1, String o2, boolean nullsFirst) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return nullsFirst ? -1 : 1;
        }
        if (o2 == null) {
            return nullsFirst ? 1 : -1;
        }
        return o1.compareToIgnoreCase(o2);
    }

    public static <T extends Comparable> Comparator<T> getComparator(final boolean nullsFirst) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return Objects.compareToNull(o1, o2, nullsFirst);
            }
        };
    }
}

