/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;

public class Stopwatch {
    private final Log log;
    private long start = System.nanoTime();

    public Stopwatch(Log log) {
        this.log = log;
    }

    public long reset() {
        if (this.log.isTraceEnabled()) {
            long now = System.nanoTime();
            long elapsed = now - this.start;
            this.start = now;
            return TimeUnit.NANOSECONDS.toMillis(elapsed);
        }
        return -1L;
    }

    public void resetAndLog(String label) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(label + ": " + this.reset() + "ms");
        }
    }
}

